; Copyright 1998 by Henter-Joyce, Inc.
; 5/18/98, A.G. added a default ReadWordInContext
; 4/27/98, A.G. added GraphicVerbosity script and AdjustJAWSVerbosity dialog 
; 4/20/98, A.G modified FocusChangedEvent to handle focus changing from object to object within the same window.
; SayFocusedObject was added.
; 4/13/98, A.G added RunJawsManager to load a JAWS utility from a list, 
; as oppose to having separate keystrokes for each manager.
;2/24/98, GG changes to allow text to be spoken as it is being unselected
;Added functions SelectingText and ProcessSelectText
; Modified functions NewTextEvent and all of the selection scripts
;SelectNextLine, select NextCharacter etc.
;1/16/98, cw - Modified SayTaskBar to make use of new FindDescendantWindow
;script function.
;1/19/98, cw - Made changes to ConfigManager, CreateDictionaryCommandLine,
;FrameManager, FrameManagerRun to add support for long filenames.

Include "hjglobal.jsh" ; default HJ global variables
Include "hjconst.jsh" ; default HJ constants
Include "default.jsm" ; message file

Const
	;UT_OutputModes
	UT_SAYTYPEANDTEXT = 0,
	UT_FOCUS = 1,
	UT_CONTROLID = 2,
	UT_CLASS = 3,
	UT_TYPE = 4,
	UT_SUBTYPE = 5,
	UT_REALNAME = 6


Void Function AutoStartEvent ()
Let GlobalMousePixel = 3
FrameClearValues ()
if (DefaultFirstTime == 0) then
	let DefaultFirstTime = 1
	If (GetVerbosity() == BEGINNER) then
        If (!IsJFWInstall()) then
		    SayString (msg371) ;"for screen sensitive help Press insert + f1"
		    SayString (msg372) ;"for JAWS Help Keys or help in dialog boxes Press Insert + H"
		    SayString (msg373) ;"for a summary of windows short cut keys Press insert + W"
        EndIf
	EndIf
EndIf ; DefaultFirstTime == 0
EndFunction

Void Function AutoFinishEvent ()
;Put code here that will be triggered when the application is finished.  
;It also gets performed when the application is switched from or looses focus, as with ALT+TAB.
EndFunction

Script  JawsWindow()
JawsWindow()
EndScript

Script JawsEnd ()
JAWSEnd()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord()
		return
	endif
endif
SayString(msg1) ;"End"
EndScript

Script JawsHome ()
JAWSHome()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord()
		return
	endif
endif
SayString(msg2) ;"Home"
EndScript

; broke  or'ed conditions into separate if statements to gain speed, 03/03/96, GG
; added test for Tab Selection Controls, 03/03/96, GG
Script SayPriorCharacter ()
var
	int TheTypeCode
PriorCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
  	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		SayString (msg3) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		SayString (msg5) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayNextCharacter () 
var
	int TheTypeCode
NextCharacter()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor() then
	SayCharacter()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
	SayWord()
	return
endif
if CaretVisible() then
	SayCharacter()
	Return
else
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
	If (TheTypeCode == WT_MENU) then
		SayString (msg3) ;"Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_STARTMENU) then
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
	if (TheTypeCode == WT_CONTEXTMENU) then
		SayString (msg5) ;"Context Menu"
		SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
		return
	EndIf
endif
EndScript

Script SayPriorLine () 
var
	int TheTypeCode
PriorLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if not IsPCCursor () then
	SayLine()
	return
endif
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible() then
	SayLine()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow ())
if ((TheTypeCode == WT_TREEVIEW) ||
	(TheTypeCode == WT_MULTISELECT_LISTBOX) ||
	(TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
EndIf
EndScript

Script SayNextLine() 
var
	int TheTypeCode
NextLine()
if (IsLeftButtonDown ()) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
if  not IsPCCursor () then
	SayLine ()
	return
EndIf
if (GetWindowTypeCode (GetCurrentWindow ()) == WT_SLIDER) then
	SayWord ()
	return
EndIf
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
EndIf
if CaretVisible () then
	SayLine ()
	return
EndIf
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	SayLine()
endif
EndScript

Script ControlUpArrow ()
var
	int MenuMode
Let MenuMode =  GlobalMenuMode
{control + up arrow}
pause ()
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	SayWord()
	return
endif
if (MenuMode > 0) then
	return
EndIf 
SayLine()
EndScript

Script  ControlDownArrow()
var
	int MenuMode,
	int TheTypeCode
Let MenuMode =  GlobalMenuMode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
if ((TheTypeCode == WT_TREEVIEW) || 
   (TheTypeCode == WT_LISTVIEW) ||
   (TheTypeCode == WT_MULTISELECT_LISTBOX) ||
   (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX)) then
	{control + down arrow} ; move without removing selection	
	pause ()
	SayLine()
	return
endif
if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL) then
	{control + down arrow}
	SayWord()
	return
endif
if (MenuMode > 0) then
	{control + down arrow}
	return
EndIf 
SayControl (GetCurrentWindow())
EndScript

Script  JawsPageDown()
JAWSPageDown()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	   GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord()
		return
	endif
endif
SayString(msg6) ;"Page down"
EndScript

Script  JawsPageUp()
JAWSPageUp()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_TABCONTROL ||
	    GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord()
		return
	endif
endif
SayString(msg7) ;"Page up"
EndScript

Script PCCursor ()
ResetSynth ()
PCCursor ()
SayString (msg10) ; "PC Cursor"
if BrailleInUse () then
	RouteBrailleToPC ()
EndIf
EndScript

Script  JawsCursor ()
ResetSynth ()
if (IsSameScript ()) then
	InvisibleCursor()
	SayString (msg11) ;"invisible Cursor"
else
	JAWSCursor ()
	SayString(msg13) ;"JAWS Cursor"
	if BrailleInUse () then
		RouteBrailleToJaws ()
	EndIf
EndIf
EndScript

Void Function SetActiveCursor (int nCursor)
if (nCursor == CURSOR_JAWS) then
	JAWSCursor ()
elif (nCursor == CURSOR_INVISIBLE) then
	InvisibleCursor()
else
	PcCursor ()
endif
EndFunction

Script  GraphicsLabeler()
GraphicsLabeler()
EndScript

Script SayDriveLetter ()
var
	int x
let x=0
InvisibleCursor ()
RouteInvisibleToPc ()
while ((GetCharacter () != "(")	&& (x<5))
	NextWord ()
	let x=x+1
endwhile
if (x != 5) then
	NextCharacter ()
	SayCharacter ()
endif
PcCursor ()
EndScript

Script  SaySpecialWindowClasses()
var
	handle WinHandle
If (GetCurrentWindow ()) then ;window handle is not 0
	if (TimesPressedDefault < 4) then
		let TimesPressedDefault = TimesPressedDefault + 1
	else
		let TimesPressedDefault = 1 ; reset it
	endif ; if times Pressed
	if TimesPressedDefault == 1 then
		let WinHandle = GetCurrentWindow ()
		while (WinHandle) ; loop until 0
			SayString (msg20) ;"Parents class ="
			SayString (GetWindowClass (GetParent (WinHandle)))
			SpellString (GetWindowClass (GetParent (WinHandle)))
			let WinHandle = GetParent (WinHandle)
		EndWhile
		return
	endif ; times pressed =1
	if (TimesPressedDefault == 2) then
		SayString (msg21) ;"Prior window class ="
		SayString (GetWindowClass (GetPriorWindow (GetCurrentWindow ())))
		SpellString (GetWindowClass (GetPriorWindow (GetCurrentWindow ())))
		return
	endif ; times pressed = 2
	if (TimesPressedDefault == 3) then
		SayString (msg22) ;"next window class ="
		SayString (GetWindowClass (GetNextWindow (GetCurrentWindow ())))
		SpellString (GetWindowClass (GetNextWindow (GetCurrentWindow ())))
		return
	endif ; times pressed = 3
	if (TimesPressedDefault == 4) then
		SayString (msg23) ;"first child window class ="
		SayString (GetWindowClass (GetFirstChild (GetCurrentWindow ())))
		SpellString (GetWindowClass (GetFirstChild (GetCurrentWindow ())))
		return
	endif ; times pressed = 4
else ; handle = 0
	SayString (msg24) ;"the window handle is 0"
	SayString (msg25) ;"This may be an item that is minimized "
	SayString (msg26) ;"press the enter key or click the mouse button to open it"
EndIf
EndScript

Script  JawsBackspace()
var
	int TheTypeCode
SaveCursor ()
PCCursor ()
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
If ((TheTypeCode == WT_TREEVIEW) || (TheTypeCode == WT_LISTVIEW)) then
	{backspace}
else
	RouteInvisibleToPc ()
	InvisibleCursor ()
	PriorCharacter ()
	SayCharacter ()
	{backspace}
endif
RestoreCursor ()
EndScript

Script JawsDelete() 
var
	int TheTypeCode
SaveCursor ()
PCCursor ()
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
{delete}
if ((TheTypeCode == WT_LISTBOX) || 
   (TheTypeCode == WT_LISTVIEW) || 
   (TheTypeCode == WT_TREEVIEW)) then
	return
EndIf
delay (1)
SayCharacter()
RestoreCursor ()
EndScript

Script  RestrictJawsCursor()
if ToggleRestriction() then
	SayString(msg27) ;"Restriction on Jaws Cursor"
else
	SayString(msg28) ;"restriction off Jaws Cursor"
endif
EndScript

Script  ShutDownJAWS()
SayString(msg29) ;"Unloading JAWS"
ShutDownJAWS()
EndScript

Script SayWindowTitle() 
var
	handle CurrentWindow,
	handle RealWindow,
	handle AppWindow,
	int TheTypeCode
let CurrentWindow = GetCurrentWindow()
if (CurrentWindow > 0) then ; handle not 0
	let RealWindow = GetRealWindow (CurrentWindow)
	let AppWindow = GetAppMainWindow (CurrentWindow)
	let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow()) 
	if GetVerbosity() == 0 then
		SayString (msg30) ;"Title ="
	EndIf
	if (IsMultiPageDialog ()) then
		SayString (GetWindowName (RealWindow))
		SayString (msg31) ;"page is"
		SayString (GetDialogPageName ())
		return
	endif
	If (TheTypeCode == WT_STARTBUTTON) then
		SayString (msg32) ;"Start Button"
		Return
	endif
	If (TheTypeCode == WT_STARTMENU) then
		SayString (msg4) ;"Start Menu"
		SayWindow (GetCurrentWindow (), READ_HIGHLIGHTED)
		Return
	EndIf
	If (TheTypeCode == WT_MENU) then
		SayString (msg3)	 ;"Menu"
		SayWindow (GetCurrentWindow (), READ_HIGHLIGHTED)
		Return
	EndIf
	If (TheTypeCode == WT_TASKBAR) then
		SayString (msg33) ;"TaskBar"
	EndIf
	If AppWindow != CurrentWindow then 
		;SayString ("App Window is ")
		SayString (GetWindowName (AppWindow))
	endif
	If ((RealWindow != AppWindow)
	   && (RealWindow != CurrentWindow)) then
		;SayString ("real Window is ")
		SayString (GetWindowName (RealWindow))
	endif
		;now say the current window
		;SayString ("current Window is ")
		SayString (GetWindowName (CurrentWindow))
else
	ScreenSensitiveHelpForUnknownClasses()  ; when handle =0
endif
EndScript

Script NextDocumentWindow() 
{control+tab}
delay (1)
if (IsMultiPageDialog ()) then
	SayString (GetDialogPageName ())
	return
endif
EndScript

Script PreviousDocumentWindow() 
{control+shift+tab}
Delay (1)
if (IsMultiPageDialog ()) then
	SayString (GetDialogPageName ())
	return
endif
EndScript

;Reads thru Dialog Box in Tab order
Script ReadBoxInTabOrder() 
var
	int safety,
	handle winhandle
let safety = 0
; figure out if we're in a dialog box
let winhandle = GetRealWindow(GetCurrentWindow())
if (GetWindowTypeCode (winhandle )== WT_DIALOG) then
	if GetVerbosity() == 0 then
		SayString (msg34) ;"Reed Box in tab order "
	EndIf
	SayString (GetWindowName (winhandle))
	; work our way through all child windows of the dialog
	; SayWindow (winhandle,0)
	if (IsMultiPageDialog ()) then
		let winhandle = GetFocus()
		while ((GetPriorWindow (winhandle)) && (Safety < 100))
			let winhandle = GetPriorWindow (winhandle)
			let Safety = Safety + 1
		endwhile
		while (IsWindowVisible (winhandle) == FALSE)
			let winhandle = GetNextWindow (winhandle)
		endwhile
	else
		let winhandle   = GetFirstChild (winhandle)
	endif
	while (winhandle)
		SayControl (winhandle)
		;SayWindow (winhandle, 0)
		;SayWindowtypeAndText (winhandle)
		let winhandle = GetNextWindow (winhandle)
	EndWhile
Elif GetVerbosity() == 0 then
	SayString(msg35) ;"Not a dialog box"
SayString("application window equals")
SayWindow (GetRealWindow (GetCurrentWindow ()), 0)
else SayWindow (GetRealWindow (GetCurrentWindow ()), 0)
endif
EndScript

; event indicating that the requested item can't be found in the OSM
Void Function ItemNotFoundEvent (int hwnd)
beep()
EndFunction

Void Function KeyPressedEvent (int nKey, string strKeyName, int nIsBrailleKey, int int)
; Add your code for KeyPressedEvent here.
; Changes made here apply to all applications.



; To make your changes application specific, copy this function to an
; application script file.
EndFunction

Void Function NewTextEvent (handle hwnd, string buffer, int nAttributes, 
int nTextColor, int nBackgroundColor, int nEcho, string sFrameName)
; Handles all newly written text.  If the text is contained in a
; frame, then the frame name is passed as a parameter
if (ProcessSelectText(nAttributes,buffer)) then
	return
endif
if (sFrameName == "") then
	; this text is not associated with a frame
	if (nAttributes& ATTRIB_HIGHLIGHT) then
		SayHighlightedText(hwnd,buffer)
	else
		SayNonHighlightedText(hwnd,buffer)
	endif
else
	; this text is associated with a frame
	if (nEcho == ECHO_NONE) then
		return; frame is being silenced
	endif
	if (nEcho  == ECHO_ALL ||
	   (nAttributes & ATTRIB_HIGHLIGHT)) then
		; if FrameEcho is set to all or the text being written is highlighted
		SayString(buffer)
	endif
endif
EndFunction

; HighlightedText event macro for speaking all newly written highlighted
; text.
Void Function SayHighLightedText (handle hwnd, string buffer)
if(GetScreenEcho() > 0) Then
	SayString(buffer)
EndIf
EndFunction

Void Function SayNonHighlightedText (handle hwnd, string buffer)
var
	string TheClass
let TheClass = GetWindowClass(hwnd)
if ((GetScreenEcho() > 1)
   ;wn36="#32771"
   || (TheClass == wn36 )) then
	SayString(buffer)
EndIf
EndFunction

Globals
	int nSelectingText
Function SelectingText(int nMode)
; handles seting up for and finishing the process of selecting text
; called by each of the scripts which does text selection
if (nMode) then
	let nSelectingText = nMode
else
	Delay(1)
	ProcessNewText()
	let nSelectingText = 0	
endif
EndFunction

Function ProcessSelectText(int nAttributes,string buffer)
; called at the beginning of the NewTextEvent to check for and
; handle speaking of text being  selected/unselected.  If this function
; returns TRUE, then the NewTextEvent abandons regular processing. 
if (nSelectingText == 0) then
	if (nAttributes & ATTRIB_UNSELECTED) then
	; only relevant when text is being selected/unselected
	; return TRUE to indicate that this text requires no further handling
		return  TRUE
	else
		return false ; allow regular processing
	endif
endif
if (nAttributes & ATTRIB_HIGHLIGHT|| nAttributes & ATTRIB_UNSELECTED) then
	if ((nAttributes & ATTRIB_UNSELECTED) && (nSelectingText != 2)) then
		let nSelectingText = 2
		SayString("Unselect ")
	elif ((nAttributes & ATTRIB_HIGHLIGHT) && (nSelectingText != 4)) then
		let nSelectingText = 4
		SayString("Select ")
	endif
	Say(buffer, OT_CHAR)
	return true
else
	return FALSE
endif
EndFunction

Script TopOfFile() 
{Control+Home}
delay (1)
If(GetVerbosity() == 0) Then
	SayString (msg37) ;"top of file"
	PCCursor()
	SayLine()
EndIf
EndScript

Script BottomOfFile() 
{Control+End}
Delay (1)
If(GetVerbosity() == 0) Then
	SayString (msg38) ;"Bottom of file"
	PCCursor()
	SayLine()
EndIf
EndScript

; Identify Font
Script SayFont () 
if GetVerbosity() == 0 then
	SayString(msg39) ;"Font equals"
EndIf
SayFont()
EndScript

; Read all selected text
Script SaySelectedText() 
If(GetVerbosity() == 0) Then
	SayString (msg40) ;"Selected text is"
EndIf
SayWindow(GetCurrentWindow(),1) ; say the highlighted text only
EndScript

Script SelectToEndOfLine()
SelectingText(TRUE)
{Shift+End}
SelectingText(FALSE)
EndScript

Script SelectFromStartOfLine() 
SelectingText(TRUE)
{Shift+Home}
SelectingText(FALSE)
EndScript

Script SelectNextLine()
SelectingText(TRUE)
{Shift+Down Arrow}
SelectingText(FALSE)
EndScript

Script SelectPriorLine() 
SelectingText(TRUE)
{Shift+Up Arrow}
SelectingText(FALSE)
EndScript

Script SelectNextCharacter()
SelectingText(TRUE)
{Shift+Right Arrow}
SelectingText(FALSE)
EndScript

Script SelectPriorCharacter() 
SelectingText(TRUE)
{Shift+Left Arrow}
SelectingText(FALSE)
EndScript

Script SelectNextWord()
SelectingText(TRUE)
{Control+Shift+Right Arrow}
SelectingText(FALSE)
EndScript

Script SelectPriorWord() 
SelectingText(TRUE)
{Control+Shift+Left Arrow}
SelectingText(FALSE)
EndScript

Script SelectNextScreen()
SelectingText(TRUE)
{Shift+Page Down}
SelectingText(FALSE)
EndScript

Script  SelectPriorScreen()
SelectingText(TRUE)
{Shift+Page Up}
SelectingText(FALSE)
EndScript

Script  SelectToBottom()
SelectingText(TRUE)
{Control+Shift+End}
SelectingText(FALSE)
EndScript

Script  SelectFromTop()
SelectingText(TRUE)
{Control+Shift+Home}
SelectingText(FALSE)
EndScript
Script CloseDocumentWindow() 
{Control+F4}
if GetVerbosity() == 0 then
	SayString(msg47) ;"Close Document Window"
EndIf
EndScript


Script OpenListBox() 
{Alt+Down Arrow}
if GetVerbosity() == 0 then
	SayString(msg48) ;"Open List Box"
EndIf
EndScript

Script CloseListBox() 
{Alt+Up Arrow}
if GetVerbosity() == 0 then
	SayString(msg48b) ;"Close List Box"
EndIf
EndScript

Script SelectAllItems() 
{Control+Slash}
if GetVerbosity() == 0 then
	SayString(msg49) ;"Select All"
EndIf
EndScript

Script UnselectAllButCurrent() 
{Control+\}
if GetVerbosity() == 0 then
	SayString(msg50) ;"Cancel All Selections in a List Except for the Current Selection"
EndIf
EndScript

Script  PassKeyThrough()
if GetVerbosity() == 0 then
	SayString(msg51) ;"Enter key to pass thru"
EndIf
PassKeyThrough()
EndScript

Function TopEdgeEvent (handle WindowHandle)
Var
	int Verbosity
let Verbosity = GetVerbosity ()
if Verbosity == 0 then
	Beep ()
	SayString (msg52) ;"Top of window"
	Return
endif
if Verbosity == 1 then
	Beep ()
	SayString (msg53) ;"Top "
	Return
endif
if Verbosity == 2 then
	Beep ()
	Return
endif
EndFunction

Function BottomEdgeEvent (handle WinHandle)
Var
	int Verbosity
let Verbosity = GetVerbosity ()
if Verbosity == 0 then
	Beep ()
	SayString (msg54) ;"Bottom of Window"
	Return
endif
if Verbosity == 1 then
	Beep ()
	SayString (msg55) ;"Bottom"
	Return
endif
if Verbosity == 2 then
	Beep ()
	Return
endif
EndFunction

Function FocusChangedEvent (handle FocusWindow, handle PrevWindow)
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow (FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow (FocusWindow)
if (GlobalPrevApp != AppWindow
	&& AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	SayWindowTypeAndText (AppWindow)
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
	|| (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
		&& (RealWindow != FocusWindow)) then
		SayWindowTypeAndText (RealWindow)
	endif
EndIf
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayFocusedWindow ()
SayWindowTypeAndText (GlobalFocusWindow)
EndFunction

Function SayFocusedObject ()
SaveCursor ()
PCCursor ()
SayObjectTypeAndText ()
RestoreCursor ()
EndFunction

Function MenuModeEvent (handle WinHandle, int mode)
;The Mode parameter indicates whether the menuBar has become active, a
;Menu  has become active, or the menus are going away.  These are
;represented by the constants MENUBAR_ACTIVE, MENU_ACTIVE, and
;MENU_INACTIVE.
Var
	int Verbosity,
	handle FocusWindow,
	handle RealWindow,
	string RealWindowName,
	handle AppWindow,
	int PrevMenuMode,
	int TheTypeCode
Let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
let PrevMenuMode = GlobalMenuMode
let GlobalMenuMode=mode
let Verbosity = GetVerbosity ()
if Verbosity == beginner then
	if (mode == MENU_INACTIVE) then
		If (PrevMenuMode == MENUBAR_ACTIVE) then
			SayString (msg58) ;"leaving menu bar"
		else
			SayString (msg59) ;"Leaving menus"
		endif
	endif ; menu inactive

	if (TheTypeCode == WT_CONTEXTMENU) then
		SayString(msg5) ;"Context Menu"
		{down arrow}; 95, say first item in menu
		return
	EndIf
	if (mode == MENUBAR_ACTIVE) then
		SayString (msg56) ;"	Menu bar"
		return
	endif ; menu bar active
	if (mode == MENU_ACTIVE) then
		if GetWindowSubTypeCode(WinHandle) == WT_STARTMENU then
			SayString(msg4) ;"Start Menu"
			{down arrow} ; 95, say first item in menu
		else
			SayString (msg57) ;"Menu active"
		endif ; if start menu
		return
	endif ; menu active
endif ; verbosity beginer
if Verbosity != beginner then
	if (TheTypeCode == WT_CONTEXTMENU) then
		{down arrow}; 95, say first item in menu
		return
	EndIf
	if (mode == MENU_ACTIVE) then
		if GetWindowSubTypeCode(WinHandle) == WT_STARTMENU then
			{down arrow} ; 95, say first item in menu
		endif ; if start menu
		return
	endif ; menu active
endif ; verbosity advanced
let FocusWindow = GetFocus()
If (FocusWindow == GlobalPrevFocus) then
	let RealWindow = GetRealWindow(FocusWindow)
	let RealWindowName = GetWindowName (RealWindow)
	let AppWindow = GetAppMainWindow(FocusWindow)
	;If (AppWindow == FocusWindow) then 
		; same app
		;SayWindowTypeAndText(AppWindow)
	;endif
	if ((verbosity == beginner)
	   && (RealWindow != FocusWindow)) then
		SayWindowTypeAndText(RealWindow)
	endif ; verbosity beginner
	;no matter what, say the window with focus
	SayWindowTypeAndText(FocusWindow)
EndIf ; focus window = global prev focus
MenuModeHook() 
EndFunction

Function MenuModeHook ()
; This macro can be added to application macro files to add onto menu mode.
EndFunction

;start of cut/paste macros
Script Undo() 
{Control+z}
if GetVerbosity() == 0 then
	SayString(msg60) ;"Undo"
EndIf
EndScript

Script CutToClipboard() 
{Control+X}
if GetVerbosity() == 0 then
	SayString(msg61) ;"Cut Selected to clipboard"
	Return
EndIf
if GetVerbosity() == 1 then
	SayString (msg62) ;"cut text"
EndIf
EndScript

Script CopyToClipboard() 
{Control+C}
if GetVerbosity() == 0 then
	SayString(msg63) ;"Copied selected text to clipboard"
	return
EndIf
if GetVerbosity() == 1 then
	SayString(msg64) ;"Copied text"
EndIf
EndScript

Script PasteFromClipboard() 
{Control+V}
if GetVerbosity() == 0 then
	SayString(msg65) ;"Pasted text from clipboard"
	Return
EndIf
if GetVerbosity() == 1 then
	SayString(msg66) ;"Pasted text"
EndIf
EndScript

;Used to refresh the screen
Script RefreshScreen ()
Refresh ()
if GetVerbosity() == 0 then
	SayString(msg67) ;"Screen Refreshed"
EndIf
if GetVerbosity() == 1 then
	SayString(msg68) ;"Refreshed"
EndIf
EndScript

Int Function IsPointInWindow (handle hwnd, int x, int y)
var
	int top,
	int left,
	int bottom,
	int right
let top = GetWindowTop (hwnd)
let left = GetWindowLeft (hwnd)
let bottom = GetWindowBottom (hwnd)
let right = GetWindowRight (hwnd)
if (left <= x && x <= right &&
	top <= y && y <= bottom) then
	return true
else
	return false
EndIf
EndFunction

Script ReadWordInContext ()
; read word in context, for spell check, find, replace, etc.
var
	handle appWindow,
	handle realWindow,
	handle focusedWindow,
	int c
let focusedWindow = GetFocus ()
let RealWindow = GetRealWindow (focusedWindow)
let appWindow = GetAppMainWindow (focusedWindow)
SaveCursor ()
JAWSCursor ()
; try to find the highlighted word starting at the top of the window
MoveToWindow (appWindow)
let c = 0;
while (FindNextAttribute (attrib_highlight) &&
	(c < 10))
	if (!IsPointInWindow (realWindow, GetCursorCol (), GetCursorRow ()) &&
		(GetCurrentWindow () != appWindow)) then
		SayLine ()
		RestoreCursor ()
		return
	EndIf
	let c = c + 1
EndWhile
MoveTo (GetWindowRight (appWindow) - 3, GetWindowBottom (appWindow) - 3)
let c = 0;
while (FindPriorAttribute (attrib_highlight) &&
	(c < 10))
	if (!IsPointInWindow (realWindow, GetCursorCol (), GetCursorRow ()) &&
		(GetCurrentWindow () != appWindow)) then
		SayLine ()
		RestoreCursor ()
		return
	EndIf
	let c = c + 1
EndWhile
SayString ("Word in context not found ")
EndScript

Script UpALevel() 
var
	int TheTypeCode
{Escape}
pause()
SaveCursor()
PCCursor()
let TheTypeCode = GetWindowSubTypeCode (GetCurrentWindow())
If (TheTypeCode == WT_MENU) then
	SayString (msg3) ;"Menu"
	SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
	return
EndIf
if (TheTypeCode == WT_STARTMENU) then
	SayString (msg4) ;"Start Menu"
	SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
	return
EndIf
if (TheTypeCode == WT_CONTEXTMENU) then
	SayString (msg5) ;"Context Menu"
	SayWindow (GetCurrentWindow(), READ_HIGHLIGHTED)
EndIf
EndScript

Script SayDefaultButton () 
var
	string DefaultButtonName
if (DialogActive ()) then
	let DefaultButtonName = GetDefaultButtonName ()
	if (DefaultButtonName != "") then
		if (GetVerbosity () == 0) then
			SayString (msg70) ;"default button is"
		endif
		SayString (DefaultButtonName)
	else
		SayString (msg444) ; "Can not determine default button in this dialog box ")
	EndIf
else
	SayString (msg71) ;"not in a dialog box"
endif
EndScript

; MOUSE FUNCTIONS
;MouseLeft Macro
Script  MouseLeft()
MouseLeft (GlobalMousePixel)
SayString (msg72) ;"Mouse Left"
EndScript

;MouseRight Macro
Script  MouseRight()
MouseRight (GlobalMousePixel)
SaySTring (msg73) ;"Mouse Right"
EndScript

;MouseDown Macro
Script  MouseDown()
MouseDown (GlobalMousePixel)
SayString (msg74) ;"Mouse Down"
EndScript

;MouseUp Macro
Script  MouseUp()
MouseUp (GlobalMousePixel)
SayString (msg75) ;"Mouse Up"
EndScript

;Control Left Mouse Click
Script  ControlLeftMouseClick()
ControlLeftMouseClick ()
SayString (msg76) ;"Control Mouse Click"
EndScript

;Shift Left Mouse Click
Script  ShiftLeftMouseClick()
ShiftLeftMouseClick ()
SayString (msg77) ;"Shift Mouse Click"
EndScript

Script  AltLeftMouseClick()
AltLeftMouseClick ()
SayString (msg77b) ;"Alt Mouse Click"
EndScript

Script JAWSFind ()
let InJAWSFind = TRUE ;flag that can be observed by other scripts
if JAWSFind () then
	SayWord ()
EndIf
let InJAWSFind = FALSE
EndScript

Script JAWSFindNext ()
var 
	int found
let found = JAWSFindNext ()
if (found==FALSE) then
	SayString(msg78) ;"search string NOT found"
else
	SayString(msg79) ;"Found"
EndIf
EndScript

Script  HomeRowToggle()
If (ToggleHomeRow () == OFF) then
	SayString (msg80) ;"Home Row Off"
Else
	SayString (msg81) ;"Home Row On"
EndIf
EndScript

Script  MouseMovementDefault()
Let GlobalMousePixel = 3
SayString (msg427) ; "Mouse Pixel setting is "
SayInteger (GlobalMousePixel)
EndScript

Script MouseMovementDecrement ()
	If (GlobalMousePixel == 1) then
		Let GlobalMousePixel = 50
	Else
		Let GlobalMousePixel = GlobalMousePixel - 1
	EndIf
	SayInteger (GlobalMousePixel)
EndScript

Script  MouseMovementIncrement()
	If (GlobalMousePixel == 50) then
		Let GlobalMousePixel = 1
	Else
		Let GlobalMousePIxel = GlobalMousePixel + 1
	EndIf
	SayInteger (GlobalMousePixel)
EndScript
	
Script SayMouseAndAnsiSettings()
var
	int SpeakAnsi
SayString (msg89) ;"Global Mouse Pixel is "
SayInteger (GlobalMousePixel)
SayString (msg90) ;"Speak Ansi Characters is set to "
Let SpeakAnsi = GetJcfOption (OPT_SPEAK_ANSI_CHARS)
If SpeakAnsi == 0 then
		SayString (msg84) ;"No Ansi"
EndIf
If SpeakAnsi == 1 then
		SayString (msg85) ;"Some Ansi"
EndIf
If SpeakAnsi == 2 then
		SayString (msg86)			 ;"More Ansi"
EndIf
If SpeakAnsi== 3 then
		SayString (msg87)			 ;"Most Ansi"
EndIf
If SpeakAnsi == 4 then
		SayString (msg82)			 ;"All Ansi"
EndIf
EndScript

Script GraphicsMode ()
var
	int GraphicsMode
Let GraphicsMode = GetJcfOption (OPT_GRAPHICS_MODE)
If (GraphicsMode == 0) then
	If (SetJcfOption (OPT_GRAPHICS_MODE, 1) == WAS_SUCCESSFUL)  then
		SayString (msg91) ;"Active Graphics Mode"
	Else
		SayString (msg92) ;"Active Graphics Mode could not be set"
	EndIf ; WAS_SUCCESSFUL
Else
	If (SetJcfOption (OPT_GRAPHICS_MODE, 0) == WAS_SUCCESSFUL)  then
		SayString (msg93) ;"Standard Graphics Mode"
	Else
		SayString (msg94) ;"Standard Graphics Mode could not be set"
	EndIf ; WAS_SUCCESSFUL
EndIf  ; GraphicsMode == 0
EndScript

Script  SayColor()
SayColor ()
EndScript

Script MinimizeAllApps ()
MinimizeAllApps ()
SayString (msg101) ;"minimize all apps"
EndScript

Script MenuBar ()
ActivateMenuBar ()
Refresh ()
EndScript

Script StartMenu ()
ActivateStartMenu ()
EndScript

; Keep JAWS from saying "space" in an extended select list box
Script SelectCurrentItem ()
var
	int TheTypeCode
{control+space}
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if (TheTypeCode ==  WT_EXTENDEDSELECT_LISTBOX) then
	SayLine()
endif
EndScript

Int Function IsSelectScriptDlg() 
var HANDLE hExecute
If (GetControlID(GetFirstChild(GetRealWindow(GetFocus()))) == ID_SELECT_DLG_LIST) then	
	;wn466 = "JAWS"
	If (GetWindowName (GetAppMainWindow (GetCurrentWindow ())) == wn466) then
		let hExecute = FindDescendantWindow (GetParent (GetCurrentWindow ()), ID_SELECT_DLG_EXECUTE)
		return (IsWindowVisible (hExecute))		
	endif
endif
	
return FALSE
EndFunction

Int Function IsSelectItemDlg ()
var HANDLE hExecute
If (GetControlID(GetFirstChild(GetRealWindow(GetFocus()))) == ID_SELECT_DLG_LIST) then	
	;wn466 = "JAWS"
	If (GetWindowName (GetAppMainWindow (GetCurrentWindow ())) == wn466) then
		let hExecute = FindDescendantWindow (GetParent (GetCurrentWindow ()), ID_SELECT_DLG_EXECUTE)
		return !(IsWindowVisible (hExecute))		
	endif
endif
	
return FALSE
EndFunction

Void Function ScreenSensitiveHelpForKnownClasses (int nSubTypeCode)
var
	int TheTypeCode,
	string RealName
let theTypeCode = nSubTypeCode
if (TheTypeCode == WT_BUTTON) then ;#1
	SayString(msg123) ;"This is a Button"
	SayString(msg124) ;"Use enter to activate it"
	SayString(msg125) ;" Use Tab to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_COMBOBOX) then ;#2
	SayString(msg126) ;"This is a Combo box"
	SayString(msg127) ;"type in a value or use the arrow keys to move between the items"
	SayString (msg127b); " use the arrow keys to move between the items"
	SayString (msg127c); "use alt plus up arrow or Escape to close the list box"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_EDIT) then ;#3
	SayString(msg129) ;"This is an edit field in which you can type information"
	SayString(msg130) ;"Use the left and right arrow keys to move through the entered text"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_LISTBOX) then ;#4
	if (IsSelectScriptDlg()) then
		SayString (msg460) ;"This is an execute item list box"
		SayString (msg132) ;"Use the arrow keys or the first letter to move to an item"
		SayString (msg461) ;"Use the space bar to toggle the selected item"
		SayString (msg462) ;"Use the enter key to close this dialog"
	elif (IsSelectItemDlg()) then
		SayString (msg463) ;"this is a select item list box"
		SayString (msg132) ;"Use the arrow keys or the first letter to move to an item"
		SayString (msg464) ;"Use enter to choose the item and exit the dialog"
		SayString (msg465) ;"Use escape to cancel the dialog"
	else
		SayString(msg131) ;"This is a list box"
		SayString(msg132) ;"Use the arrow keys or the first letter to move to an item"
		SayString(msg133) ;"Use Enter to select it"
		SayString(msg128) ;"Use the Tab key to move to the next Control"
	endif
	Return
EndIf
if (TheTypeCode == WT_SCROLLBAR) ||
(TheTypeCode ==WT_LEFTRIGHTSCROLLBAR)  
 then ;#5
	SayString(msg134) ;"This is a scroll bar"
	SayString (msg135) ;"Use the right arrow down arrow or page down keys to increase the value"
	SayString (msg136) ;"Use the left arrow up arrow or page up keys to decrease the value"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
elif  (TheTypeCode ==WT_UPDOWNSCROLLBAR) Then 
	SayString(msg454) ;"This is an Up Down scroll bar"
	SayString (msg455) ;"Use the right arrow down arrow or page down keys to decrease the value"
	SayString (msg456) ;"Use the left arrow up arrow or page up keys to increase the value"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
EndIf
if (TheTypeCode == WT_STATIC) then ;#6
	SayString(msg137) ;"This is static text for information only"
	SayString(msg138) ;"Use the reading keys to read the text"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
EndIf
if (TheTypeCode == WT_TOOLBAR) then ;#7
	SayString (msg139) ;"this is a tool bar"
	SayString (msg140) ;"it contains various controls and graphics"
	SayString (msg141) ;"it is generally accessed with the mouse by point and click"
	SayString (msg142) ;"most tool bar items can also be found within menus"
	Return
endif
if (TheTypeCode == WT_STATUSBAR) then ;#8
	SayString (msg143) ;"This is an application status bar"
	SayString (msg144) ;"It provides a variety of information depending on the focus"
	SayString (msg145) ;"by default jaws will read this with insert plus page down"
	Return
endif
if (TheTypeCode == WT_HEADERBAR) then ;#9
	SayString (msg146) ;"This is a header bar"
	SayString (msg147) ;"it contains titles for various columns below the header bar"
	SayString (msg148) ;"clicking on a particular title"
	SayString (msg149) ;"will generally sort the list based on the information in that column"
	Return
endif
if (TheTypeCode == WT_SPINBOX) then ;#12
	SayString (msg150) ;"This is a spin box"
	SayString (msg151) ;"you can edit this control manually or"
	SayString (msg152) ;"arrow up or down arrow to increase or decrease its value"
	Return
endif
;WT_MENU = 13,
if (TheTypeCode == WT_MENU) then
	SayString(msg153) ;"This is a menu"
	SayString(msg154) ;"Use the arrow keys to move between the items"
	SayString (msg119) ;"Use Say Character to read the hot key"
	SayString (msg120) ;"use the hotkey as a shortcut key or"
	SayString(msg155) ;"Press Enter to select the current item"
	Return
EndIf
;WT_DESKTOP = 14,
if (TheTypeCode == WT_DESKTOP) then
	SayString (msg156) ;"This is the desktop"
	SayString (msg157) ;"This is the area underlying all application windows"
	Return
EndIf
;WT_ICONTITLE = 16,
if (TheTypeCode == WT_ICONTITLE) then
	SayString (msg158) ;"This is an Icon Title resulting from a minimized group or application"
	If (IsJAWSCursor ()) then
		SayString (msg159) ;"Press the left mouse button to activate"
		Return
	EndIf
	If (IsPCCursor ()) then
		SayString (msg160) ;"Press enter to activate"
		Return
	EndIf
EndIf
;WT_MDICLIENT = 17,
if (TheTypeCode == WT_MDICLIENT) then
	SayString (msg161) ;"This is an multiple document interface client window"
	SayString (msg162) ;"This is the space underlying documents in an m d i environment"
	Return
EndIf
;WT_DIALOG = 18,
if (TheTypeCode == WT_DIALOG) then
	SayString(msg163) ;"This is a dialog box"
	SayString(msg164) ;"Use the tab keys to move between the fields"
	Return
EndIf
;WT_RADIOBUTTON = 19,
if (TheTypeCode == WT_RADIOBUTTON) then
	SayString(msg165) ;"This is one of a group of radio buttons"
	SayString (msg166) ;"only one can be checked at a time"
	SayString(msg167) ;"Use the up and down arrow keys to move the check mark"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_CHECKBOX = 20,
if (TheTypeCode == WT_CHECKBOX) then
	SayString(msg168) ;"This is a check box"
	SayString(msg169) ;"Use the space bar to toggle the check mark on and off"
	SayString (msg170) ;"Read current line or word to read it"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
EndIf
;WT_GROUPBOX = 21,
if (TheTypeCode == WT_GROUPBOX) then
	SayString (msg171) ;"This is a groupbox"
	If (GetVerbosity () == 0) then
		SayString (msg172) ;"It is used to group items that are related"
		SayString (msg173) ;"such as radio buttons"
	EndIf
	SayString (msg174) ;"use the pc cursor to move between the controls"
	Return
EndIf
;WT_SDM = 23,
if (TheTypeCode == WT_SDM) then
	SayString (msg163) ;"This is a dialog box"
	SayString (msg175) ;"use tab and shift tab to move between the controls"
	SayString (msg176) ;"select ok to accept the changes or cancel to ignore the changes"
	Return 
EndIf
;WT_GENERALPICTURE= 25,
if (TheTypeCode == WT_GENERALPICTURE) then
	SayString (msg177) ;"This is a General picture"
	SayString (msg178 + msg179) ;" functions or designs specific to the application"
	Return
EndIf
;WT_HOTKEY = 28,
if (TheTypeCode == WT_HOTKEY) then
	SayString (msg180) ;"This is a hot key or short cut key edit control"
	SayString (msg181) ;"be careful or you may define a short cut key by pressing any letter key"
	SayString (msg182) ;"or most combinations of letter key and alt control or shift"
	SayString (msg183) ;"use the tab key to move to the next control"
	Return
EndIf
;WT_TABCONTROL=29,
if (TheTypeCode == WT_TABCONTROL) then
	SayString (msg184) ;"This is a tab control found in multi page dialog boxes"
	SayString (msg185) ;"use the arrow keys to move between the tabs"
	SayString (msg186) ;"use the tab key to move between the controls in the dialog box"
	Return
EndIf
;WT_LISTVIEW=30,
if (TheTypeCode == WT_LISTVIEW) then
	let RealName = GetWindowName (GetRealWindow (GetCurrentWindow()))
;wn187="Desktop"
	if RealName == wn187 then
		SayString (msg188) ;"This is the desktop list view"
		SayString (msg189) ;"It contains shortcut icons"
		SayString (msg190) ;"use the arrow keys to move from item to item"
		SayString (msg191) ;"or press the first letter of the desired item"
		SayString (msg192) ;"Press enter or double click to select"
		SayString (msg193) ;"Press tab to move to the start button or shift + tab to move to the task bar"
		SayString (msg194) ;"if the desktop items are not being read correctly"
		SayString (msg195) ;"you may need to minimize all applications"
		SayString (msg196) ;"this can be accomplished with insert plus f6"
		Return
	else
		SayString (msg197) ;"This is a list view"
		SayString (msg198) ;"use the arrow keys to read through the items"
		SayString (msg199) ;"or press the first letter to jump to a desired item"
		SayString (msg200) ;"items can be contained in one or more columns"
		SayString (msg201) ;"to select a contiguous group of items"
		SayString (msg202) ;"hold down the shift key as you arrow up or down"
		SayString (msg203) ;"to select a non contiguous group of items"
		SayString (msg204) ;"hold down the control key as you arrow up and down"
		SayString (msg205) ;"and use control plus space bar"
		SayString (msg206) ;" to select or unselect items"
		SayString (msg207) ;"to here the items that have been selected"
		SayString (msg208) ;"use shift plus insert plus down arrow"
		SayString (msg209) ;"we recommend that you put files in a single column with all details"
		SayString (msg210) ;"by selecting details from the view menu"
		Return
	EndIf
EndIf
;WT_TREEVIEW=31,
if (TheTypeCode == WT_TREEVIEW) then
	SayString (msg211) ;"Tree view level "
	SayInteger (GetTreeViewLevel ())
	SayString (msg212) ;"use up or down arrow to read through the items"
	SayString (msg213) ;"or press the first letter to jump through the list"
	SayString (msg214) ;"use the right or left arrow keys to open or close an item or"
	SayString (msg215) ;"use shift with the plus or minus key"
	SayString (msg216) ;"to move to the prior level press backspace"
	SayString (msg217) ;"to move to the root of the tree press home"
	SayString (msg218) ;"to move to the last item on the tree press end"
	Return
EndIf
;WT_STARTBUTTON=32,
if (TheTypeCode == WT_STARTBUTTON) then
	SayString (msg219) ;"This is the start button"
	SayString (msg220) ;"Press Enter to open the start menu"
	SayString (msg221) ;"items in the start menu are used to launch applications"
	SayString (msg222) ;"or tab to move to the task bar"
	SayString (msg223) ;"you can use control plus escape to activate this menu at any time"
	Return
EndIf
;WT_STARTMENU=33,
if (TheTypeCode == WT_STARTMENU) then
	SayString(msg224) ;"This is the start menu"
	SayString (msg225) ;"items in this menu are used to launch applications"
	SayString(msg226) ;"Use up or down arrow to move between the items"
	SayString (msg119) ;"Use Say Character to read the hot key"
	SayString(msg155) ;"Press Enter to select the current item"
	Return
EndIf
;WT_CONTEXTMENU=34,
if (TheTypeCode == WT_CONTEXTMENU) then
	SayString(msg227) ;"This is the context menu"
	SayString(msg226) ;"Use up or down arrow to move between the items"
	SayString (msg119) ;"Use Say Character to read the hot key"
	SayString(msg155) ;"Press Enter to select the current item"
	Return
EndIf
;WT_task bar=35
if (TheTypeCode == WT_TASKBAR) then
	SayString (msg228) ;"This is the task bar"
	SayString (msg229) ;" it contains the currently running applications"
	SayString (msg185) ;"use the arrow keys to move between the tabs"
	SayString (msg230) ;" use enter to invoke the application"
	SayString (msg231)	 ;"use alt plus enter to open the task bar properties dialog"
	SayString (msg232) ;"use the tab key to move to the desktop"
	Return
EndIf
;WT_MULTISELECT_LISTBOX=37,
if (TheTypeCode == WT_MULTISELECT_LISTBOX) then
	SayString (msg233) ;"This is a multiselect listbox"
	SayString (msg201) ;"to select a contiguous group of items"
	SayString (msg234) ;"hold down the shift key as you arrow up and down"
	SayString (msg203) ;"to select a non contiguous group of items"
	SayString (msg204) ;"hold down the control key as you arrow up and down"
	SayString (msg235) ;"and use the space bar to select the item"
	SayString (msg207) ;"to here the items that have been selected"
	SayString (msg208) ;"use shift plus insert plus down arrow"
	Return
endif
;WT_EXTENDEDSELECT_LISTBOX=38,
if (TheTypeCode == WT_EXTENDEDSELECT_LISTBOX) then
	SayString (msg236) ;"This is an extended select list box"
	SayString (msg201) ;"to select a contiguous group of items"
	SayString (msg234) ;"hold down the shift key as you arrow up and down"
	SayString (msg237) ;"use shift + f8 to toggle the extended select option"
	SayString (msg238) ;"When the extended select option is on"
	SayString (msg239) ;"you can select multiple items with your space bar"
	SayString (msg207) ;"to here the items that have been selected"
	SayString (msg208) ;"use shift plus insert plus down arrow"
	Return
endif	
if (TheTypeCode == WT_LEFTRIGHTSLIDER) then ;#39
	SayString (msg240) ;"This is a horizontal slider"
	SayString (msg241) ;"the value of the control increases as you move to the right"
	SayString (msg242) ;"this type of control is frequently used to control settings such as"
	SayString (msg243) ;"volume or pitch"
	Return
endif
if (TheTypeCode == WT_UPDOWNSLIDER) then ;#40
	SayString (msg244) ;"This is a vertical slider"
	SayString (msg245) ;"the value of the control increases as you move upward"
	SayString (msg242) ;"this type of control is frequently used to control settings such as"
	SayString (msg243) ;"volume or pitch"
	Return
endif
;WT_EDITCOMBO = 41
if (TheTypeCode == WT_EDITCOMBO) then ;#41
	SayString (msg246) ;"This is an edit Combo box"
	SayString (msg127) ;"type in a value or use alt plus down arrow to open the list box"
	SayString (msg127b); " use the arrow keys to move between the items"
	SayString (msg127c); "use alt plus up arrow or Escape to close the list box"
	SayString (msg128) ;"Use the Tab key to move to the next Control"
	SayString (msg247 + msg248) ;" previously selected items"
	Return
endif
;WT_PASSWORDEDIT=42,
if (TheTypeCode == WT_PASSWORDEDIT) then ;#42
	SayString (msg249) ;"This is a password edit control"
	SayString (msg250 + msg251) ;" visually replaced by asteriks"
	SayString (msg252) ;"Use the backspace to delete and start over"
	SayString(msg128) ;"Use the Tab key to move to the next Control"
	Return
endif
if (TheTypeCode == WT_READONLYEDIT) then ;#43
	SayString (msg253) ;"This text is reed only"
	SayString (msg254) ;"you can navigate and read text with the jaws cursor"
	SayString (msg255) ;"but you cannot edit the text"
	Return
endif
if (theTypeCode == WT_COMMANDBAR) then ;#44
	SayString (msg406);"This is a command bar"
	SayString (msg407);"it consists of a row of buttons"
	SayString (msg408) ;"you can arrow left or right to hear the different button names"
	SayString (msg409) ;"and press enter to activate a button"
	SayString (msg410) ;"press control plus tab to move to the next command bar"
	SayString (msg411) ;"press escape to leave the command bar"
	return
endif
if (GlobalMenuMode == MENUBAR_ACTIVE) then
	SayString (msg117) ;"This is the menu bar"
	SayString (msg118) ;"you can arrow left and right to hear the different menu names"
	SayString (msg119) ;"Use Say Character to read the hot key"
	SayString (msg120) ;"use the hotkey as a shortcut key or"
	SayString (msg121) ;"press enter or down arrow to open a menu"
	SayString (msg122) ;"press escape to exit the menu bar"
	return
endif
;if it gets this far it did not recognize the type code.
SayString (msg256) ;"The Type Code is"
SayInteger (TheTypeCode)
ScreenSensitiveHelpForUnknownClasses (); catch everything not yet handled
EndFunction

Script ScreenSensitiveHelp () 
var
	handle WinHandle,
	int TheTypeCode,
	String TheClass
if (IsSameScript ()) then
	AppFileTopic()
	return
EndIf
if (GlobalMenuMode == 1) then
	ScreenSensitiveHelpForKnownClasses (wt_MenuBar);
	return
EndIf
let WinHandle = GetCurrentWindow ()
let TheTypeCode = GetWindowSubTypeCode (WinHandle)
if (TheTypeCode < 1) then
	let TheClass = GetWindowClass (WinHandle)
	if (theClass == "TTY" || theClass == "TTYGrab") then
		SayString (msg422) ;"This is a DOS Window"
		SayString (msg423) ;"you can close this window by typing exit and pressing the enter key"
		SayString (msg424) ;"to switch between this window and your other applications"
		SayString (msg425) ;"use alt + tab"
		return
	endif
	ScreenSensitiveHelpForUnknownClasses()  ; handle unknown window types and classes
else
	ScreenSensitiveHelpForKnownClasses (theTypeCode); known types
EndIf
EndScript

Function ScreenSensitiveHelpForUnknownClasses ()
var
	String TheClass
let TimesPressedDefault = 0 
If (GetCurrentWindow ()) then ;window handle is not 0
	Let TheClass = GetWindowClass (GetCurrentWindow ())
	SayString (msg116) ;"This is a custom window type"
	SayString (msg257) ;"Control i d = "
	SayInteger (GetCurrentControlID ())
	SayString (msg258) ;"class ="
	SayString (TheClass)
	SpellString (TheClass)
else ; handle = 0
	SayString (msg259) ;"there is currently no item with focus"
	SayString (msg260) ;"press insert+f6 to get to the desk top"
	SayString (msg261) ;"or alt plus tab to read the apps on the task bar"
	SayString (msg261b);"or control+escape for the start menu"
EndIf
EndFunction

Script  ScreenSensitiveHelpTechnical()
var
	String TheClass
Let TheClass = GetWindowClass (GetCurrentWindow ())
SayString (msg257) ;"Control i d = "
SayInteger (GetCurrentControlID ())
SayString (msg258) ;"class ="
SayString (TheClass)
SpellString (TheClass)
SayString (msg429) ; " Handle = "
SayInteger (GetCurrentWindow ())
EndScript

Script WindowKeysHelp ()
WindowKeysHelpDefault ()
EndScript
	
; List of some basic Windows keyboar commands
Void Function WindowKeysHelpDefault ()
SayString(msg262) ;"The Following windows keyboard commands can be useful"
SayString (msg269) ;"To open the start menu use control plus escape"
SayString (msg270) ;"for windows help press f1"
SayString (msg271) ;"to exit an application use alt plus f4"
SayString (msg268) ;"to access an application menu bar use the alt key"
SayString (msg272);"to rotate between the taskbar start button and desktop"
SayString (msg272b + msg272c);"press control plus escape escape and then press tab to "
		 ;" cycle between the three"
SayString (msg273) ;"to display a context menu for a selected item use shift plus f10"
SayString (msg274)		 ;"to display the properties dialog use alt plus enter"
EndFunction

Function CursorChangedEvent (int CursorType)
Let GlobalCursorType = CursorType
If (IsJAWSCursor ()) then
	PerformScript SayCursorType () 
EndIf
EndFunction

Script SayCursorType() 
if (SayCursorChange == false) then
	return
EndIf ; not on
If (GlobalCursorType == CT_ARROW) then
	Say (msg275,OT_CURSOR) ;"Arrow Cursor"
	Return
EndIf
If (GlobalCursorType == CT_IBEAM) then
	Say (msg276,OT_CURSOR) ;"I beam cursor"
	Return
EndIf
If (GlobalCursorType == CT_WAIT) then
;	Say ("Please wait",OT_CURSOR)
	Return
EndIf
If (GlobalCursorType == CT_CROSS) then
	Say (msg277,OT_CURSOR) ;"cross hair cursor"
	Return
EndIf
If (GlobalCursorType == CT_UPARROW) then
	Say (msg278,OT_CURSOR) ;"up arrow cursor"
	Return
EndIf
If (GlobalCursorType == CT_SIZE) then
	Say (msg279,OT_CURSOR) ;"sizing cursor"
	Return
EndIf
If (GlobalCursorType == CT_ICON) then
	Say (msg280,OT_CURSOR) ;"icon cursor"
	Return
EndIf
If (GlobalCursorType == CT_SIZENWSE) then
	Say (msg281,OT_CURSOR) ;"north east south west cursor"
	Return
EndIf
If (GlobalCursorType == CT_SIZEWE) then
	Say (msg282,OT_CURSOR) ;"east west cursor"
	Return
EndIf
If (GlobalCursorType == CT_SIZENS) then
	Say (msg283,OT_CURSOR) ;"north south cursor"
	Return
EndIf
If (GlobalCursorType == CT_UNKNOWN) then
	Say (msg284,OT_CURSOR) ;"hand cursor"
	Return
EndIf
SayString (msg285) ;"Cursor Changed"
EndScript
			
Void Function HotKeyHelpDefaultLoop ()
var
	handle WinHandle,
	String RealClassName,
	String HelpPhrase,
	handle Hndl,
	int FoundHotKey,
	int SDMControlHandle,
	int WinTypeCode,
	int IsDialog

Let FoundHotKey = 0
Let IsDialog = DialogActive ()
Let hndl = GetRealWindow (GetFocus ())
Let RealClassName = GetWindowClass (hndl)
InvisibleCursor ()
;wn286="sdm"
if (StringContains (RealClassName, wn286)) then ; THIS IS AN SDM WINDOW
	Let IsDialog = ACTIVE
	Let WinHandle = GetRealWindow (GetFocus ())
	Let SDMControlHandle = SDMGetFirstControl (WinHandle)
	While (SDMControlHandle)
		MoveToControl (WinHandle, SDMControlHandle)
		;wn287=""
		if (GetHotKey () != wn287) then
			if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
				SayString (msg288) ;"Hot keys are as follows"
			EndIf
			;wn289=" use alt  "
			Let HelpPhrase = GetChunk () + wn289 + GetHotKey ()
			SayString (HelpPhrase)
			let FoundHotKey = 1
		EndIf
		if (IsMultiPageDialog ()) then
			let WinHandle = GetCurrentWindow()
		EndIf
		let SDMControlHandle = SDMGetNextControl (WinHandle, SDMControlHandle)
	EndWhile
else ; Not SDM Window
	Let WinHandle = GetRealWindow (GetFocus ())
	Let WinHandle=GetFirstChild (WinHandle)
	While (WinHandle)
		let WinTypeCode = GetWindowTypeCode (WinHandle)
		If ((WinTypeCode == WT_BUTTON) ||
			(WinTypeCode == WT_STATIC) ||
			(WinTypeCode == WT_RADIOBUTTON) ||
			(WinTypeCode == WT_CHECKBOX) ||
			(WinTypeCode == WT_GROUPBOX) || 
			(WinTypeCode == WT_3STATE) ||
			(WinTypeCode == WT_TABCONTROL)) then 
			MoveToWindow (WinHandle)
			If hndl != GetRealWindow (GetCurrentWindow ()) then
				PCCursor ()
				return
			EndIf
			;wn287=""
			if (GetHotKey() != wn287) then
				if ((FoundHotKey == 0) && (GetVerbosity() == BEGINNER)) then
					SayString (msg288) ;"Hot keys are as follows"
				EndIf
				;wn289=" use alt  "
				Let HelpPhrase = GetChunk () + wn289 + GetHotKey()
				SayString (HelpPhrase)
				let FoundHotKey = 1
			EndIf
		EndIf ; condition for static text or button
		Let WinHandle = GetNextWindow (WinHandle)
	EndWhile
EndIf
PcCursor ()
If (FoundHotKey == 0) then
	If (IsDialog) then ;only say this string if in a dialog
		;"unable to determine hot keys in this dialog"
		SayString (msg450)
	EndIf
	GeneralJAWSHotKeys ()
EndIf
EndFunction

Void Function GeneralJAWSHotKeys ()
SayString (msg292) ;"Here are some jaws hot keys for general use"
SayString (msg293 + GetScriptKeyName ("ScreenSensitiveHelp")) ;"Screen sensitive help message use Insert plus F1"
SayString (msg475 + GetScriptKeyName ("ScreenSensitiveHelp") + msg476) ; "JAWS Help for applications Use Insert+F1 pressed twice quickly"
SayString (msg294 + GetScriptKeyName ("WindowKeysHelp")) ;"Windows tips on navigation Use Insert plus W"
SayString (msg295 + GetScriptKeyName ("SayWindowTitle")) ;"to reed window titles use Insert plus T"
SayString (msg296 + GetScriptKeyName ("JAWSWindow")) ;"to activate JAWS window use Insert plus J "
SayString (msg297 + GetScriptKeyName ("MinimizeAllApps")) ;"To minimize all applications on the desktop use insert plus f6"
SayString (msg298 + GetScriptKeyName ("ShutDownJAWS")) ;"to unload jaws at any time use Insert plus F4"
SayString (msg477 + GetScriptKeyName ("RunJAWSManager")) ; To open a JAWS utility such as Configuration Manager or Keyboard Manager use "
SayString (msg302 + GetScriptKeyName ("JAWSFind")) ;"to access the Jaws search dialog use Insert plus Control plus F "
SayString (msg303 + GetScriptKeyName ("AdjustJAWSVerbosity")) ;"to toggle verbosity levels use Insert plus V "
SayString (msg305 + GetScriptKeyName ("SayColor")) ;"to Say the screen color at the active cursor use Insert plus numbers row 5"
SayString (msg306 + GetScriptKeyName ("RestrictJAWSCursor")) ;"to Restrict the jaws Cursor use Insert plus R"
SayString (msg307 + GetScriptKeyName ("SayFont")) ;"to identify font at the active cursor use Insert plus F "
SayString (msg308 + GetScriptKeyName ("ReadBoxInTabOrder")) ;"to Reed Dialog Box in Tab Order use Insert plus B"
SayString (msg309 + GetScriptKeyName ("RefreshScreen")) ;"to refresh screen use Insert plus escape  "
SayString (msg310) ;"For a more complete list activate the JAWS Window"
SayString (msg311) ;"Press ALT+H and then Q for Quick Reference"
EndFunction

Int Function JAWSHotKeys ()
if (IsSelectScriptDlg ()) then
	SayString (msg467) ;"This is an execute item dialog"
	;msg468 = "Use "	msg469 = " for help specific to each control"
	SayString (msg468 + GetScriptKeyName ("ScreenSensitiveHelp") + msg469)
	SayString (msg470) ;"to execute the selected item once use alt e"
	SayString (msg471) ;"to exit this dialog use enter or escape"
	return TRUE
elif (IsSelectItemDlg ()) then
	SayString (msg472) ;"this is a select item dialog"
	;msg468 = "Use "	msg469 = " for help specific to each control"
	SayString (msg468 + GetScriptKeyName ("ScreenSensitiveHelp") + msg469)
	SayString (msg464) ;"Use enter to choose the item and exit the dialog"
	SayString (msg465) ;"Use escape to cancel the dialog"
	return TRUE
endif

return FALSE
EndFunction

; Insert H help messages
Script HotKeyHelp()
if (JAWSHotKeys()) then
	return
endif
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Int Function HotKeyHelpDefault ()
;may not be correct always, hard coded, may remove it, 4/11/97, th
; Insert h text for Open File Dialog box.
;wn312="File Open"
var int ID
let ID = GetControlID(GetFocus())

if (GetWindowName (GetRealWindow (GetFocus())) == wn312) ||
	;wn313="Save"
	(GetWindowName (GetRealWindow (GetFocus())) == wn313) then
	SayString(msg314) ;"you can type in a path and file name then enter or"
	SayString(msg315) ;"You can Tab through the controls or jump using the following Windows hot keys"
	SayString(msg316) ;"For the list of disk drives, use Alt V then type the drive letter"
	SayString(msg317) ;"To select the path use Alt D for the directories list box"
	SayString(msg318) ;"Now type the first letter for each directory or subdirectory"
	SayString(msg319) ;"To choose the type of files you are looking for, Use Alt T"
	SayString(msg320) ;"Now arrow thru the list to find your choice"
	SayString(msg321) ;"Use Alt N to return to File Name edit box and type in a name or tab to list box"
	SayString(msg322) ;"Now you can type the first letter of the file you want and then enter"
	SayString(msg323) ;"Use escape to cancel"
	Return TRUE
EndIf
; Insert h text for Save As Dialog box.
;wn324="Save As"
if (GetWindowName (GetRealWindow (GetFocus())) == wn324) then
	SayString(msg325) ;"type in a path and file name then enter or"
	SayString(msg315) ;"You can Tab through the controls or jump using the following Windows hot keys"
	SayString(msg316) ;"For the list of disk drives, use Alt V then type the drive letter"
	SayString(msg317) ;"To select the path use Alt D for the directories list box"
	SayString(msg318) ;"Now type the first letter for each directory or subdirectory"
	SayString(msg326) ;"To choose the file type you would like to save it as, Use Alt T"
	SayString(msg327) ;"Use the down arrow and find your choice"
	SayString(msg328) ;"Use Alt N to return to File Name edit box and type in a name"
	SayString(msg323) ;"Use escape to cancel"
	Return TRUE
EndIf
; Insert h for Print Setup dialog.
;wn329="Print Setup"
if (GetWindowName (GetRealWindow (GetFocus())) == wn329) then
	Saystring(msg330) ;"Tab through the controls to make selections or use the following Windows keys"
	Saystring(msg331) ;"To select Default printer use Alt D"
	Saystring(msg332) ;"To select specific printer use Alt P"
	SayString(msg333) ;"To select Paper size use Alt Z"
	SayString(msg334) ;"To select Paper source use Alt S"
	Saystring(msg335) ;"Printing Portrait use Alt R"
	Saystring(msg336) ;"Printing Landscape use Alt L"
	SayString(msg337) ;"For other printing options use Alt O"
	Return TRUE
EndIf
Return FALSE  ; did not handle
EndFunction

Script SayCurrentHotKey() 
;wn287=""
if (GetHotKey() == wn287) then
	SaysTring (msg338) ;"no hot key"
	return	
endif
SayString (GetHotKey())
EndScript

Void Function MoveToFirstSdmControl ()
var
	int SDMControl,
	handle winhandle
let winhandle = GetRealWindow (GetFocus())
let SDMControl = SDMGetFirstControl (winhandle)
MoveToControl (winhandle, SDMControl)
let GlobalSDMControl = SDMControl
EndFunction

Void Function MoveToNextSdmControl ()
var
	int SDMControl,
	handle winhandle
let winhandle = GetRealWindow (GetFocus())
let SDMControl = SDMGetNextControl (GetCurrentWindow(), GlobalSDMControl)
MoveToControl (GetCurrentWindow(), SDMControl)
let GlobalSDMControl = SDMControl
EndFunction

;Copyright 1996 by Henter-Joyce, Inc.
;default macro file for desk tops
; 2/12/95, added SDM windows, focus change & insert+f1 macros.
; 4/27, added PassKeyThrough
; & separated to use include file.
; added hjglobal.jmh header file
;and new Focus Change,8/8/95, th.

Script  ScriptFileName()
ScriptAndAppNames("default")
EndScript

Script  SayLine()
SayLine ()
EndScript

Script  SayCharacter()
if IsPCCursor() then
	if (GetWindowTypeCode(GetCurrentWindow()) == WT_SLIDER) then
		SayWord() ; says the current setting
		return
	endif
endif
if (IsSameScript ()) then
	SayCharacterPhonetic ()
	AddHook (HK_SCRIPT, "PhoneticSpellHook")
else
	SayCharacter()
EndIf
EndScript

Void Function PhoneticSpellHook (string ScriptName)
if (ScriptName == "SayNextCharacter") then
	NextCharacter ()
	SayCharacterPhonetic ()
	return False
EndIf
if (ScriptName == "SayPriorCharacter") then
	PriorCharacter ()
	SayCharacterPhonetic ()
	return False
EndIf
RemoveHook (HK_SCRIPT, "PhoneticSpellHook")
return True
EndFunction

Script SayWord()
If (IsSameScript ()) Then
	SpellWord()
	AddHook (HK_SCRIPT, "SpellWordHook")
Else
	SayWord()
EndIf
EndScript

Void Function SpellWordHook (string ScriptName)
if (ScriptName == "SayNextWord") then
	NextWord ()
	SpellWord ()
	return false
EndIf
if (ScriptName == "SayPriorWord") then
	PriorWord ()
	SpellWord ()
	return false
EndIf
RemoveHook (HK_SCRIPT, "SpellWordHook")
return true
EndFunction

Script SayNextWord()
NextWord()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
SayWord()
EndScript

Script SayPriorWord() 
PriorWord()
if ((IsLeftButtonDown()) || (IsRightButtonDown())) then
	SelectingText(TRUE)
	pause ()
	SelectingText(false)
	return
EndIf
SayWord()
EndScript

Script  SayActiveCursor()
if (IsLeftButtonDown ()) then
	SayString (msg430) ; "the left mouse button is locked"
EndIf
If (IsRightButtonDown ()) then
	SayString (msg431) ; "the right mouse button  is locked"
EndIf
SayActiveCursor()
SayCursorPos(GetActiveCursor())
EndScript

Script  RouteJawsCursorToPc()
if (IsInvisibleCursor ()) then
	RouteInvisibleToPc ()
	SayString(msg377) ;"Route invisible to p c"
else
	RouteJawsToPc()
	JAWSCursor()
	SayString(msg378) ;"Route jaws to p c"
endif
EndScript

Script  RoutePCCursorToJaws()
if (IsInvisibleCursor ()) then
	RoutePCToInvisible ()
	SayString(msg379b) ;"Route p c to invisible"
else
	RoutePcToJaws()
	SayString(msg379) ;"Route p c to jaws"
endif
PCCursor()
EndScript

Script  SayAll()
SayAll()
EndScript

Script  LeftMouseButton()
SayString(msg380) ;"left mouse button"
LeftMouseButton()
EndScript

Script  RightMouseButton()
SayString(msg381) ;"right mouse button"
RightMouseButton()
EndScript

; toggle the pressed/released state of the left mouse button
Script  LeftMouseButtonLock()
if LeftMouseButtonLock () then
	SayString(msg382) ;"left button locked"
else
	SayString(msg383) ;"Left button unlocked"
endif
EndScript

Globals
	int DragAndDropSet,
	int DragFromX,
	int DragFromY,
	string DragObject

Script DragAndDrop ()
var
	int x,
	int y,
	String object
if (DragAndDropSet == false) then
	let DragFromX = GetCursorCol ()
	let DragFromY = GetCursorRow ()
	let DragObject = GetWord ()
	let DragAndDropSet = true
	; msg412 = "place the JAWS or PC cursor in the drop location and press " 
	SayString (msg412 + GetCurrentScriptKeyName () + msg413)
	return
EndIf
SaveCursor ()
let x = GetCursorCol ()
let y = GetCursorRow ()
JawsCursor ()
; make sure that the left mouse button is unlocked
If IsLeftButtonDown () then
	LeftMouseButtonLock ()
	pause ()
EndIf
MoveTo (DragFromX, DragFromY)
Pause ()
let object = GetWord()
if object != DragObject then
	Let DragAndDropSet = false
	SayString (msg415) ; "Object to be dragged not found"
	SayString (msg416) ; "this may be because it has been covered by another window"
	SayString (msg417) ; "drag and drop action has been canceled"
	return
EndIf
LeftMouseButtonLock () ; lock it down
pause ()
MoveTo (x,y)
Pause ()
;msg418 = "dragging "
SayString (Msg418 +object+msg419)
SayWord()
LeftMouseButtonLock () 
RestoreCursor ()
Let DragAndDropSet = false
EndScript

Function DragAndDropClearValues ()
let DragAndDropSet = false
EndFunction

; toggle the pressed/released state of the right mouse button
Script RightMouseButtonLock ()
if RightMouseButtonLock () then
	SayString(msg384) ;"right button locked"
else
	SayString(msg385) ;"right button unlocked"
EndIf
EndScript

Script SayTopLineOfWindow()
SaveCursor()
InvisibleCursor()
RouteInvisibleToPC()
JawsPageUp()
SayLine()
RestoreCursor()
EndScript

Script SayBottomLineOfWindow() 
var
	int TheTypeCode
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
SaveCursor()
InvisibleCursor()
RouteInvisibleToPC()
if (TheTypeCode == WT_MENU) then
	MoveToWindow (GetAppMainWindow (GetCurrentWindow()))
	JAWSPageDown ()
	JAWSHome()
	NextWord()
	SayChunk()
else
	JawsPageDown()
	SayLine()
endif
RestoreCursor()
EndScript

Script  SayToCursor()
SayToCursor()
EndScript

Script  SayFromCursor()
SayFromCursor()
EndScript

Script  SayWindowPromptAndText()
SayWindowTypeAndText(GetCurrentWindow())
EndScript

Function Unknown (string TheName, int IsScript)
if IsScript then
	SayString (msg432 + TheName) ; "unknown script call to "
else
	SayString (msg433 + TheName) ; "unknown function call to "
EndIf
EndFunction

;*************************
;     Utility Scripts         *
;*************************
Script  UtilityHelp()
;{homerow + insert+ h}
SayString (msg339) ;"Define current window use f1"
SayString (msg340) ;"Move to next window use tab"
SayString (msg341) ;"Move to prior window use shift plus tab"
SayString (msg342) ;"Move to child window use f2"
SayString (msg343) ;"Move to parent window use shift plus f2"
SayString (msg344) ;"Move to next attribute use grave accent"
SayString (msg345) ;"Move to prior attribute use shift plus grave accent"
SayString (msg346) ;"Move to first attribute use control plus grave accent"
SayString (msg347) ;"Move to last attribute use control plus shift plus grave accent"
SayString (msg348) ;"Adjust the output mode use f3"
SayString (msg349) ;"Adjust the Font mode use f4"
SayString (msg350) ;"Read the Prior Window use p"
EndScript

; Find the next requested attribute after the caret
Script  UtilityNextAttribute()
;{homerow+grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindNextAttribute (UT_FontMode)) then
	SayField ()
	return
endif
if (FindFirstAttribute (UT_FontMode)) then
	beep()
	SayField ()
	return
endif	
SayString (msg351) ;"next attribute not found"
EndScript

; Find the prior requested attribute before the caret
Script  UtilityPriorAttribute()
;{homerow+shift+grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindPriorAttribute (UT_FontMode)) then
	SayField ()
	return	
endif
If (FindLastAttribute (UT_FontMode)) then
	beep()
	SayField()
	return
endif
SayString (msg352) ;"prior attribute not found"
EndScript

; Find the first requested attribute
Script  UtilityFindFirstAttribute()
;{homerow + control + grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindFirstAttribute (UT_FontMode)) then
	SayWord ()
Else
	SayString (msg353) ;"First Attribute not found"
EndIf
EndScript

; Find the last requested attribute
Script  UtilityFindLastAttribute()
;{homerow + shift+control + grave accent}
If (UT_FontMode == 0) then
	Let UT_FontMode = ATTRIB_BOLD
EndIf
If (FindLastAttribute (UT_FontMode)) then
	SayWord ()
Else
	SayString (msg354) ;"Last Attribute not found"
EndIf
EndScript

; produces the requested ouput on the current window
Script  UtilitySayInfoAccess()
;{homerow+f1}
var
	HANDLE hGrip,
	Int bSpellMode 
Let hGrip = GetCurrentWindow ()
If (IsSameScript ()) then
	Let bSpellMode = ON
Else
	Let bSpellMode = OFF
EndIf
UtilitySayInfo(hGrip, bSpellMode)
EndScript

Script  UtilityPutInfoInBox()
;{homerow + Insert + f1}
If (UT_OutputMode == UT_FOCUS ||
   UT_OutputMode == UT_CONTROLID ||
   UT_OutputMode == UT_SUBTYPE	) then
	SayString (msg355) ;"Message box not available for Focus or Control ID"
EndIf
If UT_OutputMode == UT_CLASS then
	SayString (GetWindowClass (GetCurrentWindow ()))
	MessageBox (GetWindowClass (GetCurrentWindow ()))
EndIf
If UT_OutputMode == UT_TYPE then
	SayString (GetWindowType (GetCurrentWindow ()))
	MessageBox (GetWindowType (GetCurrentWindow ()))
EndIf
If UT_OutputMode == UT_REALNAME then
	SayString (GetWindowName (GetRealWindow (GetCurrentWindow ())))
	MessageBox (GetWindowName (GetRealWindow (GetCurrentWindow ())))
EndIf
EndScript
Script  UtilityMoveToNextWindow()
;{homerow+shift+tab}
var 
	HANDLE hGrip
let hGrip = GetNextWindow(getCurrentWindow())
while  (hGrip && !IsWindowVisible(hGrip))
let hGrip = GetNextWindow(hGrip)
endwhile
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
SayString("no next window")
endif
EndScript

;Cycle backword through windows at the same level
Script  UtilityMoveToPriorWindow()
;{homerow+shift+tab}
var 
	HANDLE hGrip
let hGrip = GetPriorWindow(GetCurrentWindow())
while  (hGrip && !IsWindowVisible(hGrip))
let hGrip = GetPriorWindow(hGrip)
endwhile
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
SayString("no prior window")
endif
EndScript

;Move down one level
Script  UtilityMoveToChild()
;{homerow+f2}
var
	HANDLE hGrip
let hGrip = GetFirstChild(getCurrentWindow())
while  (hGrip && !IsWindowVisible(hGrip))
let hGrip = GetNextWindow(hGrip)
endwhile
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
	SayString (msg358) ;"Child window not found"
endif
EndScript

;Move up one level
Script  UtilityMoveToParent()
;{homerow+shift+f2}
var
	HANDLE hGrip
Let hGrip = GetParent(GetCurrentWindow ())
if  (hGrip && MoveToWindow (hGrip)) then
UtilitySayInfo(hGrip, FALSE) ;produces the requested output
else
	SayString (msg359) ;"Parent window not found"
endif
EndScript

;Adjust UT_OutputMode
Script UtilitySetOutputMode ()
;{homerow+f3}
If UT_OutputMode == UT_REALNAME then
	Let UT_OutputMode = UT_SAYTYPEANDTEXT
Else
	Let UT_OutputMode = UT_OutputMode + 1
EndIf
PerformScript UtilitySayOutputMode ()
EndScript

;Thanks to John Squally for writing the UtiltitySayOutputMode and 
;UtilitySetOutputModeReverseOrder scripts as part of his participation 
;in a Henter-Joyce script writing workshop.
Script UtilitySetOutputModeReverseOrder ()
;{Homerow+Shift+F3}
If UT_OutputMode == UT_SAYTYPEANDTEXT then
	Let UT_OutputMode = UT_REALNAME
Else
	Let UT_OutputMode = UT_OutputMode - 1
EndIf
PerformScript UtilitySayOutputMode ()
EndScript

Script UtilitySayOutputMode ()
If UT_OutputMode == UT_SAYTYPEANDTEXT then
	SayString (msg360b) ;"Say Type and Text"
EndIf
If UT_OutputMode == UT_FOCUS then
	SayString (msg360) ;"focus"
EndIf
If UT_OutputMode == UT_CONTROLID then
	SayString (msg361) ;"control i d"
EndIf
If UT_OutputMode == UT_CLASS then
	SayString (msg362) ;"Class"
EndIf
If UT_OutputMode == UT_TYPE then
	SayString (msg363) ;"Type"
EndIf
If UT_OutputMode == UT_SUBTYPE then
	SayString (msg364) ;"Sub type code"
EndIf
If UT_OutputMode == UT_REALNAME then
	SayString (msg365) ;"Real name"
EndIf
EndScript

;Adjust UT_FontMode
Script  UtilitySetFontMode()
;{homerow+f4}
If (UT_FontMode == 0 ) then
	Let UT_FontMode = ATTRIB_HIGHLIGHT
EndIf
If UT_FontMode == ATTRIB_HIGHLIGHT then
	Let UT_FontMode = ATTRIB_BOLD
Else
	If UT_FontMode == ATTRIB_STRIKEOUT then
		Let UT_FontMode = UT_FontMode * 4
	Else
		Let UT_FontMode = UT_FontMode * 2
	EndIf
EndIf
If UT_FontMode == ATTRIB_BOLD then
	SayString (msg366) ;"bold"
EndIf
If UT_FontMode == ATTRIB_ITALIC then
	SayString (msg367) ;"italics"
EndIf
If UT_FontMode == ATTRIB_UNDERLINE then
	SayString (msg368) ;"underline"
EndIf
If UT_FontMode == ATTRIB_STRIKEOUT then
	SayString (msg369) ;"highlight"
EndIf
If UT_FontMode == ATTRIB_HIGHLIGHT then
	SayString (msg370) ;"strike out"
EndIf
EndScript

;Called by utilities to speak the requested information
Void Function UtilitySayInfo (handle hGrip, int bSpellMode)
If (UT_OutputMode == UT_SAYTYPEANDTEXT) then
	SayWindowTypeAndText (hGrip)
EndIf
If (UT_OutputMode == UT_FOCUS) then
	SayInteger (hGrip)
EndIf
If (UT_OutputMode == UT_CONTROLID) then
	SayInteger (GetControlID (hGrip))
EndIf
If (UT_OutputMode == UT_CLASS) then
	If (bSpellMode) then
		SpellString (GetWindowClass (hGrip))
	Else
		SayString (GetWindowClass (hGrip))
	EndIf
EndIf
If (UT_OutputMode == UT_TYPE) then
	If (bSpellMode) then
		SpellString (GetWindowType (hGrip))
	Else
		SayString (GetWindowType (hGrip))
	EndIf
EndIf
If (UT_OutputMode == UT_SUBTYPE) then
		SayInteger (GetWindowSubTypeCode (hGrip))
EndIf
If (UT_OutputMode == UT_REALNAME) then
	If (bSpellMode) then
		SpellString (GetWindowName (GetRealWindow (hGrip)))
	Else
		SayString (GetWindowName (GetRealWindow (hGrip)))
	EndIf
EndIf
EndFunction

Script  UtilitySayPrompt()
;{homerow + P}
SayControl (GetPriorWindow (GetCurrentWindow ()))
EndScript

Script UtilityResetOutputMode ()
SayString (msg434) ; "output mode is"
Let UT_OutputMode = UT_SAYTYPEANDTEXT 
SayString (msg360b) ;"Say Type and Text"
EndScript

;Set Handle to first visible child window
Function UtilitySetHandleToFirstVisible (handle hGrip)
;{homerow+alt+shift+control+tab}
var
	int safety
	let safety = 0
while ((GetPriorWindow (hGrip)) && (Safety < 100))
	let hGrip = GetPriorWindow (hGrip)
	let Safety = Safety + 1
endwhile
while (IsWindowVisible (hGrip) == FALSE)
	let hGrip = GetNextWindow (hGrip)
endwhile
EndFunction

;Set handle to last visible child window
Void Function UtilitySetHandleToLastVisible (handle hGrip)
;{homerow+alt+control+tab}
var
	int safety
	let safety = 0
while ((GetNextWindow (hGrip)) && (Safety < 100))
	let hGrip = GetNextWindow (hGrip)
	let Safety = Safety + 1
endwhile
while (IsWindowVisible (hGrip) == FALSE)
	let hGrip = GetPriorWindow (hGrip)
endwhile
EndFunction

Script  SayFrame(string FrameName)
SayFrame (FrameName)
EndScript

Script  SayFrameAtCursor()
SayFrameAtCursor ()
EndScript

Void Function ScriptAndAppNames (string sFileName)
var
string theString

let theString = sFileName
If (GetVerbosity() == beginner) Then
	let theString = theString + msg374 ;" settings are loaded"
else
	let theString = theString + msg374b ; " settings"
endif
SayString (theString)
If(GetVerbosity() == beginner) Then
	SayString (msg376) ;"The application currently being used is the "
EndIf
SayString (GetAppFileName ())
SpellString (GetAppFileName ())
EndFunction



Script ClearValues()
FrameClearValues ()
DragAndDropClearValues ()
BrailleSelectTextClearValues ()
SayString (msg437) ; "Values Cleared"
EndScript

;**********************************
;     Extended Key Scripts  *
;**********************************

Script  SayNextCharacterPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayNextCharacter()
EndScript

Script  SayPriorCharacterPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayPriorCharacter()
EndScript

Script  SayNextLinePCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayNextLine()
EndScript

Script  SayPriorLinePCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayPriorLine()
EndScript

Script  SayNextWordPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayNextWord()
EndScript

Script  SayPriorWordPCCursor()
SaveCursor ()
PcCursor ()
PerformScript SayPriorWord()
EndScript

Script  ControlDownArrowPCCursor()
SaveCursor ()
PcCursor ()
PerformScript ControlDownArrow()
EndScript

Script  ControlUpArrowPCCursor()
SaveCursor ()
PcCursor ()
PerformScript ControlUpArrow()
EndScript

;*************************
;     Braille Scripts         *
;*************************

Script BrailleToggleCursor()
; Toggle between the JAWS and PC cursor
if (IsPCCursor ()) then
	PerformScript JawsCursor ()
else
	PerformScript PCCursor ()
EndIf
EndScript

Script BrailleToggleMode () 
if (GetBrailleMode() == BRL_MODE_LINE) then
	SetBrailleMode(BRL_MODE_STRUCTURED)
	SayString (msg438) ; "Structured Mode"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_attrib) then
	SetBrailleMode(BRL_MODE_STRUCTURED)
	SayString (msg438) ; "Structured Mode"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_STRUCTURED) then
	SetBrailleMode(BRL_MODE_speechbox)
	SayString ("Speech Box Mode")
	return
EndIf
if (GetBrailleMode() == BRL_MODE_speechbox) then
	SetBrailleMode(BRL_MODE_line)
	SayString (msg439) ; "Line Mode"
EndIf
EndScript

Script BrailleMovesActive ()
if (GetJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR) == 1) then
	SetDefaultJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR, 0)
	SayString (msg448) ; "The active cursor will not follow the Braille cursor"
else
	SetDefaultJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR, 1)
	SayString (msg449) ; "The active cursor will follow the Braille cursor"
endIf
EndScript

Script ActiveMovesBraille ()
;  Determins wether or not the braille display follows the active cursor
if (GetJcfOption (	OPT_BRL_AUTO_ROUTE_TO_CURSOR) == 1) then
	SetDefaultJcfOption (	OPT_BRL_AUTO_ROUTE_TO_CURSOR, 0)
	SayString (msg451) ; "The active cursor will not move the Braille cursor"
else
	SetDefaultJcfOption (	OPT_BRL_AUTO_ROUTE_TO_CURSOR, 1)
	SayString (msg452) ; "The active cursor will move the Braille cursor"
beep()
endIf

EndScript

Script BrailleToggleCharactersAndAttributes()
if (GetBrailleMode() == BRL_MODE_LINE) then
	SetBrailleMode (BRL_MODE_attrib)
	SayString (msg440) ; "Attributes"
	return
EndIf
if (GetBrailleMode() == BRL_MODE_attrib) then
	SetBrailleMode (BRL_MODE_line)
	SayString (msg441) ; "characters"
	return
EndIf
SetBrailleMode (BRL_MODE_line)
SayString (msg439) ; "Line Mode"
EndScript

Script BrailleTab()
{Tab}
EndScript

Script BrailleShiftTab ()
{Shift+Tab}
EndScript

Script BrailleEnter()
{Enter}
EndScript

Script BrailleEscape() 
{Esc}
EndScript

Script BrailleAltTab ()
{Alt + Tab}
EndScript

Script BraillePriorLine () 
if (GetBrailleMode() == BRL_MODE_SPEECHBOX) then
	PriorBrailleString()
ElIf BrailleIsStructuredLine () then
	PriorLine ()
else
	if (GetJcfOption (OPT_BRL_MOVE_ACTIVE_CURSOR) == 0) then
		SaveCursor()
		BrailleCursor()
	EndIf
	PriorLine()
EndIf
EndScript

Script BrailleNextLine ()
if (GetBrailleMode () == BRL_MODE_SPEECHBOX) then
	NextBrailleString ()
elif BrailleIsStructuredLine () then
	NextLine ()
else
	if (GetJcfOption(OPT_BRL_MOVE_ACTIVE_CURSOR) == 0) then
		SaveCursor ()
		BrailleCursor ()
	EndIf
	NextLine ()
EndIf
EndScript

Script BraillePanLeft() 
# If there is more text to the left on the current line, display it.
# If not, display the final segment of the previous line.
var
	int PrevCursorRow,
	int PrevCursorCol,
	int NewCursorRow,
	int NewCursorCol
if (GetJcfOption(OPT_BRL_MOVE_ACTIVE_CURSOR) == 0) then
	SaveCursor()
	BrailleCursor()
EndIf
if not BraillePanLeft () then
	if (GetBrailleMode() == BRL_MODE_Speechbox) then
		if (PriorBrailleString ()) then
			while (BraillePanRight ())
			endwhile
		endif
	ElIf not BrailleIsStructuredLine() then
		let PrevCursorCol = GetCursorCol()
		let PrevCursorRow = GetCursorRow()
		PriorLine()
		let NewCursorCol = GetCursorCol()
		let NewCursorRow = GetCursorRow()
		if (NewCursorCol != PrevCursorCol ||
			NewCursorRow != PrevCursorRow) then
		; cursor has moved, so display new line
		; display the end of the previous line if the whole thing won't fit on
		; the display
			while (BraillePanRight() )
			endwhile
		; we've now moved the cursor such that the final part of the line is displayed
		else
		; Cursor didn't move, so send an error beep
			Beep()
		EndIf
	EndIf
EndIf
EndScript

Script BraillePanRight () 
# If there is more text on the current line, then display it.
# Otherwise, display the first segment of the next line.
var
	int PrevCursorRow,
	int PrevCursorCol,
	int NewCursorRow,
	int NewCursorCol
if (GetJcfOption(OPT_BRL_MOVE_ACTIVE_CURSOR) == 0) then
	SaveCursor ()
	BrailleCursor ()
EndIf
if not BraillePanRight () then
	if (GetBrailleMode() == BRL_MODE_SPEECHBOX) then
		if (NextBrailleString()) then
			while (BraillePanLeft())
			endwhile
		endif
	elif not BrailleIsStructuredLine () then
		let PrevCursorCol = GetCursorCol()
		let PrevCursorRow = GetCursorRow()
		NextLine()
		let NewCursorCol = GetCursorCol()
		let NewCursorRow = GetCursorRow()
		if (NewCursorCol != PrevCursorCol ||
			NewCursorRow != PrevCursorRow) then
		; cursor has moved, so display new line
			while (BraillePanLeft())
			endwhile
		; we've now moved so that the first part of the line is displayed
			BrailleLine ()
		else
		; Cursor didn't move, so send an error beep
			Beep()
		EndIf
	EndIf
EndIf
EndScript

Script BrailleMoveLeft ()
if (GetJcfOption(OPT_Brl_Move_Active_Cursor) == 0) Then
	SaveCursor()
	BrailleCursor()
endif
if not BraillePanLeft() then
Beep()
endif
EndScript

Script BrailleMoveRight ()
if (GetJcfOption(Opt_Brl_Move_Active_Cursor) == 0) Then
	SaveCursor()
	BrailleCursor()
endif
if not BraillePanRIGHT() then 
Beep()
endif
EndScript

Script BrailleToggle8PixelsPerSpace ()
If (GetJcfOption(Opt_Pixels_Per_Space) == 999) Then  ; Current setting is unlimited
  PerformScript BrailleSet8PixelsPerSpace()
Else
  PerformScript BrailleSetUnlimittedPixelsPerSpace()
EndIf
EndScript

Script BrailleRouting()
var
	int nX,
	int nY,
	int nCell
let nCell = GetLastBrailleRoutingKey ()
let nX = GetBrailleCellColumn (nCell)
let nY = GetBrailleCellRow (nCell)
if (nY == 0) then
	return
EndIf
if (GetJcfOption(OPT_BRL_MOVE_ACTIVE_CURSOR) == 0) then
	SaveCursor ()
	BrailleCursor ()
	MoveTo (nX,nY)
	RestoreCursor()
	if IsPCCursor () then
		RoutePCToBraille ()
	elif IsJawsCursor () then
		RouteJAWSToBraille ()
		LeftMouseButton()
	else
	EndIf
else
	MoveTo (nX,nY)
EndIf
EndScript

Void Function BrailleBuildLine ()
var
 handle hwndReal,
 string buffer,
 string CheckedUnchecked,
int PixelsPerSpace
let PixelsPerSpace=GetJcfOption (	OPT_PIXELS_PER_SPACE)
SetJcfOption (	OPT_PIXELS_PER_SPACE, 99)
if MenusActive ()
then
BrailleBuildMenu()
Return TRUE
elif
DialogActive ()
Then 
BrailleBuildDialog()
return TRUE
elif 
(GetWindowTypeCode (GetFocus())==WT_LISTVIEW ||
GetWindowTypeCode (GetFocus())==WT_LISTBOX ||
GetWindowTypeCode (GetFocus())==WT_TREEVIEW ||
GetWindowTypeCode (GetFocus())==WT_STARTBUTTON ||
GetWindowTypeCode (GetFocus())==WT_DESKTOP ||
GetWindowTypeCode (GetFocus())==WT_TASKBAR)
then BrailleBuildOther()
 Return TRUE
else 
return FALSE
endif
SetJcfOption (	OPT_PIXELS_PER_SPACE, PixelsPerSpace)
EndFunction

Void Function BrailleBuildMenu ()
if GetJcfOption (OPT_BRL_verbosity)==0 ||
 GetJcfOption (OPT_BRL_verbosity)==1
then 
if (GetMenuMode () == MENUBAR_ACTIVE) then
 BrailleAddString (msg56,0,0,0) ; "Menu bar"
 BrailleAddFocusLine ()
 return TRUE
ElIf (GetMenuMode () == MENU_ACTIVE) then
 if (GetWindowSubTypeCode(GetCurrentWindow()) == WT_STARTMENU) then
 BrailleAddString (msg4,0,0,0) ; "Start menu"
 BrailleAddFocusLine()
 ElIf (GetWindowSubTypeCode(GetCurrentWindow()) == WT_CONTEXTMENU) then
 BrailleAddString (msg5,0,0,0) ; "Context menu"
BrailleAddFocusLine ()
 else
 BrailleAddString (GetMenuName () + msg445,0,0,0) ; " menu"
BrailleAddFocusLine ()
 EndIf
return TRUE
endif ; end beginner verbosity
elif GetJcfOption (OPT_BRL_Verbosity)==2 
then 
 if (GetMenuMode () == MENUBAR_ACTIVE) then
 BrailleAddFocusLine ()
 return TRUE
ElIf (GetMenuMode () == MENU_ACTIVE) then
 if (GetWindowSubTypeCode(GetCurrentWindow()) == WT_STARTMENU) then
 BrailleAddFocusLine()
 ElIf (GetWindowSubTypeCode(GetCurrentWindow()) == WT_CONTEXTMENU) then
BrailleAddFocusLine ()
 else
BrailleAddFocusLine ()
 EndIf
return TRUE
endif
endif  
EndFunction

Function BrailleBuildDialog (handle HWNDReal, string Buffer, string CheckedUnchecked)

 let hwndReal = GetRealWindow (GetFocus ())
 let Buffer = GetWindowName (hwndReal) ; title of the dialog box
if GetJcfOption (OPT_BRL_Verbosity)==0  then 
 if (buffer != "") then ; there is a title
 BrailleAddString(buffer + " dlg",0,0,0)
 endif
 let buffer = GetDialogPageName()
 if (buffer != "") then ; there is a page name
 BrailleAddString(buffer + " page",0,0,0)
 endif
 let buffer = GetDialogStaticText()
 if (buffer != "") then ; there is static text in dialog
 BrailleAddString(buffer + " ",0,0,0)
 endif
 let buffer = GetGroupBoxName()
 if (buffer != "") then ; there is a GroupBox name
 BrailleAddString(buffer + " gb",0,0,0)
 endif
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 let CheckedUnchecked = "<x> "
 else
 let CheckedUnchecked = "< > "
 endif
 else
 let CheckedUnchecked = ""
 endif
 let buffer = GetControlName()
 if (buffer != "") &   
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " +GetWindowType(GetFocus()),
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer+" "+"Button", GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX || 
 GetWindowTypeCode(GetFocus()) == WT_ListBOX || 
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)  
then
BrailleAddString (buffer+" "+GetWindowType (GetFocus ()), 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
; end beginer verbosity 
elif  GetJcfOption (OPT_BRL_Verbosity)==1 then
 if (buffer != "") then ; there is a title
 BrailleAddString(buffer + "_",0,0,0)
 endif
 let buffer = GetDialogPageName()
 if (buffer != "") then ; there is a page name
 BrailleAddString(buffer + "_",0,0,0)
 endif
 let buffer = GetDialogStaticText()
 if (buffer != "") then ; there is static text in dialog
 BrailleAddString(buffer + " ",0,0,0)
 endif
 let buffer = GetGroupBoxName()
 if (buffer != "") then ; there is a GroupBox name
 BrailleAddString(buffer + "_",0,0,0)
 endif
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 let CheckedUnchecked = "<x> "
 else
 let CheckedUnchecked = "< > "
 endif
 else
 let CheckedUnchecked = ""
 endif
 let buffer = GetControlName()
 if (buffer != "") &   
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " ,
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer+" "+"Button", GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX || 
 GetWindowTypeCode(GetFocus()) == WT_ListBOX || 
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)  
then
BrailleAddString (buffer, 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
; end intermediate verbosity  
elif GetJcfOption (OPT_BRL_verbosity)==2  then 
 if ControlCanBeChecked () then
 if  (ControlIsChecked ()) then
 let CheckedUnchecked = "<x> "
 else
 let CheckedUnchecked = "< > "
 endif
 else
 let CheckedUnchecked = ""
 endif
 let buffer = GetControlName()
 if (buffer != "") &   
 (GetWindowTypeCode(GetFocus()) == WT_RADIOBUTTON ||
 GetWindowTypeCode(GetFocus()) == WT_CHECKBOX) then
 BrailleAddString (CheckedUnchecked+buffer + " " ,
GetCursorCol (), GetCursorRow (), 32)
 elif GetWindowTypeCode (GetFocus ()) ==WT_BUTTON
then BrailleAddString (buffer, GetCursorCol (), GetCursorRow (), 0)
Return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_EDIT ||
 GetWindowTypeCode(GetFocus()) == WT_COMBOBOX || 
 GetWindowTypeCode(GetFocus()) == WT_ListBOX || 
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
 GetWindowTypeCode(GetFocus()) == WT_TREEVIEW)  
then
BrailleAddString (GetControlName (), 0, 0, 0)
 BrailleAddFocusItem()
  Return TRUE
 endif
endif
EndFunction

Void Function BrailleBuildOther (string Buffer)
if (GetWindowSubtypeCode(GetCurrentWindow()) == WT_LISTVIEW) &&
 (GetWindowName(GetRealWindow(GetCurrentWindow())) == WN187) then
 BrailleAddString (msg446,0,0,0) ; "Desktop"
 BrailleAddFocusItem ()
return TRUE
elif (GetWindowSubtypeCode(GetFocus()) == WT_TASKBAR) then
 BrailleAddString (msg447,0,0,0) ; "Task Bar"
 BrailleAddFocusLine()
 return TRUE
elif (GetWindowSubtypeCode(GetFocus()) == WT_STARTBUTTON) then
 BrailleAddFocusItem()
 return TRUE
elif (GetWindowTypeCode(GetFocus()) == WT_COMBOBOX || 
GetWindowTypeCode(GetFocus()) == WT_ListBOX || 
GetWindowTypeCode(GetFocus()) == WT_LISTVIEW  ||
GetWindowTypeCode(GetFocus()) == WT_TREEVIEW ||
GetWindowTypeCode (GetFocus ()) == WT_button) 
then
if GetJcfOption (OPT_BRL_Verbosity)==0
then 
let Buffer = GetWindowType (GetFocus ())
BrailleAddString (Buffer, 0, 0, 0)
 BrailleAddFocusItem()
else  BrailleAddFocusItem()
endif 
Return TRUE 
else Return FALSE
endif
EndFunction

Script BrailleTop ()
if not BrailleIsStructuredLine () then
	SaveCursor ()
	BrailleCursor ()
	RouteBrailleToPC ()
	JAWSPageUp ()
	JAWSHome ()
	SayString (msg52) ; "top of window"
else
	while (BraillePanLeft ())
	EndWhile
	SayString ("Beginning of line")
EndIf
EndScript

Script BrailleBottom ()
if not BrailleIsStructuredLine () then
	SaveCursor ()
	BrailleCursor ()
	RouteBrailleToPC ()
	JAWSPageDown ()
	JAWSEnd ()
	SayString (msg54) ; "bottom of window"
else
	while (BraillePanright ())
	EndWhile
	SayString ("End of line")
EndIf
EndScript

Script BrailleSet8PixelsPerSpace()
SayString (msg390) ;"8 pixels per space"
SetJcfOption(OPT_PIXELS_PER_SPACE,8)
EndScript

Script BrailleSetUnlimittedPixelsPerSpace()
SayString(msg391) ;"Unlimitted pixels per space"
SetJcfOption(OPT_PIXELS_PER_SPACE,999)
EndScript

Script BrailleToggleMarking()
var
	int markingNow
let markingNow = GetJcfOption(OPTBRL_MARKING)
if (markingNow >= BRL_MARKING_ALL) then
	let markingNow = BRL_MARKING_NONE
else
	let markingNow = markingNow+1
endif
SetJcfOption(OPTBRL_MARKING,markingNow)
if (markingNow == BRL_MARKING_NONE) then
	SayString(msg392) ;"Braille marking off"
	return
endif
if (markingNow == BRL_MARKING_HIGHLIGHT) then
	SayString(msg393) ;"Braille marking  highlight"
	return
endif
if (markingNow == BRL_MARKING_BOLD) then
	SayString(msg394)  ;"Braille marking  bold"
	return
endif
if (markingNow == BRL_MARKING_UNDERLINE) then
	SayString(msg395) ; "Braille marking  underline"
	return
endif
if (markingNow == BRL_MARKING_ITALIC) then
	SayString(msg396) ; "Braille marking  italic"
	return
endif
if (markingNow == BRL_MARKING_STRIKEOUT) then
	SayString(msg397) ; "Braille marking  strike out"
	return
endif
if (markingNow == BRL_MARKING_ALL) then 
	SayString(msg398) ; "Braille marking all "
	return
endif
EndScript

Script  BrailleTurnMarkingOff()
SetJcfOption (OPTBRL_MARKING, BRL_MARKING_NONE)
SayString(msg392) ;"Braille marking off"
EndScript

script BrailleDescribeFont()
var
	int nX,
	int nY,
	int nCell
let nCell = GetLastBrailleRoutingKey()
if (nCell > 0) then
	let nX = GetBrailleCellColumn(nCell)
	let nY = GetBrailleCellRow(nCell)
	SaveCursor()
	InvisibleCursor()
	MoveTo(nX,nY)
	SayFont()
	RestoreCursor()
EndIf
EndScript

Script  BrailleToggle8Dots()
var
	int EightDot
let EightDot = GetJcfOption (OPTBRL_EIGHT_DOT)
if (EightDot) then
	SetJcfOption (OPTBRL_EIGHT_DOT, FALSE)
	SayString (msg399) ;"six dot braille"
else
	SetJcfOption (OPTBRL_EIGHT_DOT, TRUE)
	SayString (msg400) ;"eight dot braille"
Endif
EndScript

Script  BrailleSet6Dots()
SetJcfOption (OPTBRL_EIGHT_DOT, FALSE)
SayString (msg399) ;"six dot braille"
EndScript

Script BrailleSet8Dots()
SetJcfOption (OPTBRL_EIGHT_DOT, TRUE)
SayString (msg400) ;"eight dot braille"
EndScript

Script RouteBrailleToPC ()
RouteBrailleToPC ()
EndScript

Script RouteBrailleToJaws ()
RouteBrailleToJaws ()
EndScript

Script RouteBrailleToActiveCursor ()
var
	int ActiveCursor
let activeCursor = GetActiveCursor ()
if (ActiveCursor == cursor_jaws) then
	RouteBrailleToJaws ()
ElIf (ActiveCursor == cursor_pc) then
	RouteBrailleToPC ()
EndIf
EndScript

Globals
	int SelectSet,
	int SelectFromX,
	int SelectFromY

Script BrailleSelectText ()
var
	int x,
	int y
if (SelectSet == false) then
	let SelectFromX = GetBrailleCellColumn (GetLastBrailleRoutingKey ())
	let SelectFromY = GetBrailleCellRow (GetLastBrailleRoutingKey ())
	let SelectSet = true
	SaveCursor ()
	BrailleCursor ()
	MoveTo (SelectFromX, SelectFromY)
	BrailleToggleCursorShape ()
	SayString ("Selecting Text")
	return
EndIf
SaveCursor ()
let x = GetBrailleCellColumn (GetLastBrailleRoutingKey ())
let y = GetBrailleCellRow (GetLastBrailleRoutingKey ())
JawsCursor ()
; make sure that the left mouse button is unlocked
If IsLeftButtonDown () then
	LeftMouseButtonLock ()
	pause ()
EndIf
MoveTo (SelectFromX, SelectFromY)
Pause ()
LeftMouseButtonLock () ; lock it down
pause ()
MoveTo (x,y)
Pause ()
LeftMouseButtonLock () 
pause ()
RestoreCursor ()
BrailleToggleCursorShape ()
Let SelectSet = false
EndScript

Function BrailleToggleCursorShape ()
if GetDefaultJCFOption (OPTBRL_ALL_DOTS_CURSOR) then
	SetDefaultJcfOption (OPTBRL_ALL_DOTS_CURSOR, 0)
else
	SetDefaultJcfOption (OPTBRL_ALL_DOTS_CURSOR, 1)
EndIf
EndFunction

Void Function BrailleSelectTextClearValues ()
if SelectSet then
	let SelectSet = false
	BrailleToggleCursorShape ()
EndIf
EndFunction

;*******
; Keyboard Help section
globals
	int nKeyboardHelpSavedTypingEcho

Script KeyboardHelp()
SayString (msg401) ; "Keyboard Help on"
let nKeyboardHelpSavedTypingEcho = GetJCFOption(OPT_TYPING_ECHO)
SetJcfOption(OPT_TYPING_ECHO,1) ; echo characters
AddHook (HK_SCRIPT, "KeyboardHelpHook")
; ignore any keys not attached to scripts
TrapKeys(TRUE)
EndScript

Void Function KeyboardHelpHook (string ScriptName, string FrameName)
if (ScriptName == "KeyboardHelp") then
	SayString(msg402) ; "Keyboard Help off"
	RemoveHook (HK_SCRIPT, "KeyboardHelpHook")
	TrapKeys(FALSE)
	SetJcfOption(OPT_TYPING_ECHO,nKeyboardHelpSavedTypingEcho)
	return FALSE
EndIf
if IsSameScript () then
	if ((FrameName != "") && (GetFrameDescription (FrameName) != "")) then
		SayString (msg420) ; "This frame "
		SayString (GetFrameDescription (FrameName))
	EndIf
	if (FrameName == "") then
		SayString(GetScriptDescription(ScriptName))
	EndIf
else
	SayString (GetCurrentScriptKeyName ()) ; says key name, "insert+up arrow"
	if (FrameName != "") then
		SayString (msg421 + FrameName) ; "says the content of the frame " 
		SayString (GetFrameSynopsis (FrameName))
	else
		SayString (ScriptName) ; will say the name of the script, "SayLine"
		SayString(GetScriptSynopsis(ScriptName))
	EndIf
EndIf
; by returning  FALSE, a hook function can prevent a script from being run
return FALSE
EndFunction

Int Function RoutePCToInvisible ()
var
int Row,
int Column,
int nSuccess
InvisibleCursor()
let Row = GetCursorRow ()
let Column = GetCursorCol ()
PCCursor()
let nSuccess = MoveTo (Column, Row)
return nSuccess
EndFunction

Script SayAppVersion ()
SayString (GetVersionInfoString (GetAppFilePath (), "ProductName") +
		" Version " + GetVersionInfoString (GetAppFilePath (), "ProductVersion"))
EndScript

Script SayProgramComments ()
SayString (GetVersionInfoString (GetAppFilePath (), "Comments"))
EndScript

Void Function RestrictCursor (int nStatus)
if (ToggleRestriction () != nStatus) then
	ToggleRestriction ()
endif
EndFunction

Script SayTaskBar ()
var
handle hWnd
let hWnd = FindTopLevelWindow ("Shell_TrayWnd", "")
let hWnd = GetFirstChild(hWnd)
if (hWnd) then
	while (hWnd && GetWindowClass (hWnd) != "MSTaskSwWClass")
		let hWnd = GetNextWindow(hWnd)
	EndWhile 
	
	let hWnd = GetFirstChild(hWnd)
	while (hWnd && GetWindowClass (hWnd) != "SysTabControl32")
		let hWnd = GetNextWindow(hWnd)
	EndWhile 

	if (GetWindowClass(hWnd) == "SysTabControl32" && !IsWindowObscured (hWnd)) then
		SayWindow(hWnd, READ_EVERYTHING)
		return
	endif
endif
SayString (msg442) ; "Task bar is not visible"
EndScript

Script SaySystemTray ()
var
handle hWnd
let hWnd = FindTopLevelWindow ("Shell_TrayWnd", "")
let hWnd = FindDescendantWindow (hWnd, 303)
if (hWnd) then
	SayWindow(hWnd, READ_EVERYTHING)
else
	SayString (msg443) ; "system tray is not visible"
endif
EndScript

Script SayTextAndAttributes ()
var
	int x,
	int y,
	handle WinHandle,
	int prevAttrib,
	int curAttrib
let WinHandle = GetFocus ()
SaveCursor ()
InvisibleCursor ()
MoveToWindow (WinHandle)
if !ToggleRestriction () then
	ToggleRestriction ()
EndIf
let prevAttrib = 1
let curAttrib = GetCharacterAttributes ()
while ((x != GetCursorCol ()) || (y != GetCursorRow ()))
let x = GetCursorCol ()
let y = GetCursorRow ()
SayAttributesChanges (prevAttrib, curAttrib)
SayField ()
NextChunk ()
let prevAttrib = curAttrib
let curAttrib = GetCharacterAttributes ()
EndWhile
if ToggleRestriction () then
	ToggleRestriction ()
EndIf
RestoreCursor ()
EndScript

String Function IntToAttribName (int attrib)
if (attrib == attrib_bold) then
	return "Bold"
EndIf
if (attrib == attrib_italic) then
	return "Italic"
EndIf
if (attrib == attrib_underline) then
	return "Underline"
EndIf
if (attrib == attrib_strikeout) then
	return "Strikeout"
EndIf
if (attrib == attrib_graphic) then
	return "Graphic"
EndIf
if (attrib == attrib_highlight) then
	return "Highlight"
EndIf
return ""
EndFunction

Void Function SayAttributesChanges (int prevAttrib, int curAttrib)
var
	int attrib
let attrib = attrib_bold
while (attrib <= attrib_highlight)
if ((prevAttrib & attrib) != (curAttrib & attrib)) then
	if (curAttrib & attrib) then
		SayString (IntToAttribName (attrib) + " on")
	else
			SayString (IntToAttribName (attrib) + " off")
	EndIf
EndIf
let attrib = attrib * 2
EndWhile
EndFunction

Function MouseMovedEvent (int x, int y)
; Add your code for KeyPressedEvent here.
; Changes made here apply to all applications.
; To make your changes application specific, copy this function to an
; application script file.
EndFunction

Int Function GetWordWidth ()
var 
int nLength,
int nPixels,
int nSafety

let nSafety = 0
let nPixels = 0

let nLength = StringLength (GetWord())
if (nLength == 0) then return  0 endif

SaveCursor()
InvisibleCursor()
RouteInvisibleToPc ()
while (nSafety < nLength)
	let nPixels = nPixels + GetCharacterWidth()
	if (IsWordDelimiter(GetCharacter())) then return nPixels endif
	NextCharacter()
	let nSafety = nSafety + 1
endwhile
return nPixels
EndFunction

Int Function IsWordDelimiter (string strChar)
if (StringLength(strChar) > 1) then 
	return 0
endif

return (StringContains (WORD_DELIMITERS, strChar) != 0)

EndFunction

Void Function GetBrailleMode ()
return GetJCFOption(OPT_BRL_MODE)
EndFunction
Void Function SetBrailleMode (int nMode)
SetDefaultJcfOption(OPT_BRL_MODE,nMode)
EndFunction

; ***
; Run Manager section
; ***

Script WindowClassReassign ()
var
	string TheApp,
	string TheClass,
	string RunIt
Let TheApp = GetAppFileName ()
Let TheClass = GetWindowClass (GetCurrentWindow())
;wn95="Invalid Window Handle"
If (TheClass == wn95) then
	;wn96="Invalid"
	Let TheClass = wn96
EndIf
;RunIt = JConfig.exe -a[Application] + -c[Class Name] + d[Dialog mode]
Let RunIt = MGR_CONFIG + " " + FLAG_APP + "\"" + TheApp + "\" " + FLAG_CLASS + "\"" + TheClass + "\"" + " " + FLAG_CLASS_MODE
RunManager (RunIt)
EndScript

Script ConfigManager ()
var
	string TheApp,
	string TheClass,
	string RunIt
Let TheApp = GetAppFileName ()
Let TheClass = GetWindowClass (GetCurrentWindow())
;wn95="Invalid Window Handle"
If (TheClass == wn95) then
	;wn96="Invalid"
	Let TheClass = wn96
EndIf
;RunIt = JConfig.exe -a[Application] + -c[Class Name]
Let RunIt = MGR_CONFIG + " " + FLAG_APP + "\"" + TheApp + "\"" + " " + FLAG_CLASS + "\"" + TheClass + "\""
RunManager (RunIt)
EndScript

String Function CreateDictionaryCommandLine (int bDoAddDialog)
var
	string theword,
	int HighlightFound,
	string TheApp,
	string Runit,
	int Period,
	HANDLE CurrentWindow
let theword = GetWord()
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".")	
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
if (GetCharacterAttributes() & ATTRIB_GRAPHIC) then
	SayString(msg428) ; "Use the Graphics Labeler to label graphics"
	return ""
endif
;See if there is highlighted text
if (IsPCCursor()) then
	SaveCursor()
	InvisibleCursor ()
	RouteInvisibleToPc ()
	if (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
		let theWord = "\""+GetField()+"\""
	else
		PriorCharacter ()
		if (GetCharacterAttributes () & ATTRIB_HIGHLIGHT) then
			let theWord = "\""+GetField()+"\""
		endif
	Endif	
	RestoreCursor()
endif
if (theword != "") then
	;RunIt = "JDiction.exe -a[Application] -r[Rule]
	Let Runit = MGR_DICTION + "  " + FLAG_APP + "\"" + TheApp + "\"  " +  FLAG_RULE + theword
	if (bDoAddDialog == TRUE) then
		Let Runit = Runit + " -d"
	endif
else
	;RunIt = "JDiction.exe -a[Application] 
	Let Runit = MGR_DICTION + "  " + FLAG_APP + "\"" + TheApp + "\""
	if (bDoAddDialog == TRUE) then
		Let Runit = Runit + " -d"
	endif
endif	
return RunIt
EndFunction

Script DictionaryManager ()
var String RunIt
;Start dictionary Manager
let RunIt = CreateDictionaryCommandLine (FALSE)
if (RunIt != "") then
	RunManager (RunIt)
EndIf
EndScript

Void Function FrameClearValues ()
let GlobalFrameTopLeft = ""
let GlobalFrameBottomRight = ""
EndFunction

Script FrameGetTopLeft ()
var
	int X,
	int Y

if (IsSameScript ()) then
	FrameSetOnWindow (GetCurrentWindow())
else
	;JAWSCursor ()
	let X = GetCursorCol ()
	let Y = GetLineTop ()
	if (!Y) then
		let Y = GetCursorRow()
	endif
	;  format Top Left Dimensions to a string
	Let GlobalFrameTopLeft = IntToString (X) + "," + IntToString (Y)
	if (GetVerbosity () == BEGINNER) then
		SayString (msg435) ; "Setting Frame top left corner "
	endif
endif
SetParentDims()
if (GlobalFrameBottomRight != "") then
	FrameManagerRun()
	; reset GlobalVariables
	let GlobalFrameTopLeft = ""
	let GlobalFrameBottomRight = ""
endif
EndScript

Script FrameGetBottomRight ()
var
	int X,
	int Y

;JAWSCursor ()
let X = GetCursorCol () + GetCharacterWidth ()
let Y = GetCursorRow ()
;  format Top Left Dimensions to a string
Let GlobalFrameBottomRight = IntToString (X) + "," + IntToString (Y)
if (GetVerbosity () == BEGINNER) then
	SayString (msg436) ; "Setting Frame bottom right corner "
endif
SetParentDims()
if (GlobalFrameTopLeft != "") then
	FrameManagerRun()
	; reset GlobalVariables
	let GlobalFrameTopLeft = ""
	let GlobalFrameBottomRight = ""
endif
EndScript

Void Function FrameSetOnWindow (handle CurrentWindow)
var
int WindowTop,
int WindowLeft,
int WindowBottom,
int WindowRight

if (!CurrentWindow) then
	let CurrentWindow = GetCurrentWindow()
endif

let WindowTop = GetWindowTop (CurrentWindow)
let WindowLeft = GetWindowLeft (CurrentWindow)
let WindowBottom = GetWindowBottom (CurrentWindow)
let WindowRight = GetWindowRight (CurrentWindow)

Let GlobalFrameTopLeft = IntToString (WindowLeft) + "," + IntToString (WindowTop)
Let GlobalFrameBottomRight = IntToString (WindowRight) + "," + IntToString (WindowBottom)
EndFunction

Void Function FrameManagerRun ()
var
	HANDLE hRealWindow,
	string sRealName,
	string sClass,
	string sID,
	string sApp,
	int nPeriod,
	string RunIt
if ((GlobalFrameTopLeft == "") || (GlobalFrameBottomRight == "")) then
	return
endif
let hRealWindow = GetTopLevelWindow (GetCurrentWindow())
let sRealName = GetWindowName(hRealWindow)
let sClass = GetWindowClass(hRealWindow)
let sID = IntToString(GetControlID(hRealWindow))
let sApp = GetAppFileName ()
let nPeriod = StringContains (sApp, ".")
let sApp = SubString (sApp, 1, nPeriod-1)
let RunIt = MGR_FRAME
let RunIt = RunIt + " "
let RunIt = RunIt + FLAG_APP + "\"" + sApp + "\""
let RunIt = RunIt + " -n\"" + sRealName
let RunIt = RunIt + "\""
let RunIt = RunIt + " -i" + sID
let RunIt = RunIt + " -c\"" + sClass
let RunIt = RunIt + "\""
let RunIt = RunIt + " -p" + GlobalFrameParentDims
let RunIt = RunIt + " -f" + GlobalFrameTopLeft + "," + GlobalFrameBottomRight
;MessageBox(RunIt)
PcCursor ()
RunManager(RunIt)
EndFunction

Function SetParentDims ()
var
	string sTLX,
	string sTLY,
	string sBRX,
	string sBRY,
	HANDLE hRealWindow,
	string TempString
let hRealWindow = GetTopLevelWindow (GetCurrentWindow ())
let sTLX = IntToString (GetWindowLeft (hRealWindow))
let sTLY = IntToString (GetWindowTop (hRealWindow))
let sBRX = IntToString (GetWindowRight (hRealWindow))
let sBRY = IntToString (GetWindowBottom (hRealWindow))
let GlobalFrameParentDims = sTLX + "," + sTLY + "," + sBRX + "," + sBRY
EndFunction

Script FrameManager ()
var
	string TheApp,
	string Runit,
	int Period,
	HANDLE CurrentWindow
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".")	
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
;RunIt = "JFrame.exe -a[Application]
Let Runit = MGR_FRAME + "  " + FLAG_APP + "\"" + TheApp + "\""
RunManager (RunIt)
EndScript

Script KeyboardManager ()
var
	string TheApp,
	string Runit,
	int Period,
	HANDLE CurrentWindow
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".")	
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
Let Runit = "jkey.exe" + "  " + "\"" + TheApp + "\""
RunManager (Runit)
EndScript

Script ScriptManager ()
var
 string TheApp,
 string Runit,
 int Period,
 HANDLE CurrentWindow
Let TheApp = GetAppFileName ()
Let Period = StringContains (TheApp, ".") 
Let TheApp = SubString (TheApp, 1, Period-1)
Let CurrentWindow = GetCurrentWindow()
Let Runit = MGR_SCRIPT + "  " + "\"" + TheApp + "\""
RunManager (Runit)
EndScript

Script  ScriptManagerDefault()
RunManager ("jscript.exe default.jss")
EndScript

Function RunManager (string strCommandLine)
var
	String RunIt
let RunIt = GetJawsDirectory () + "\\" + strCommandLine
Run(RunIt)
;MessageBox(RunIt)
EndFunction

Script RunJAWSManager ()
var
	string managersList,
	int index
let managersList = ConfigManItem + 
	WindowClassItem + 
	DictionManItem + 
	FrameManItem + 
	KeyManItem + 
	ScriptManItem+ 
	GraphicsLabelerItem;
let index = DlgSelectItemInList (ManagersList, RunManagerDialogTitle, TRUE);
pause ();
if (index == 1) then
	PerformScript ConfigManager ();
elif (index == 2) then
	PerformScript WindowClassReassign ();
elif (index == 3) then
	PerformScript DictionaryManager ();
elif (index == 4) then
	PerformScript FrameManager ();
elif (index == 5) then
	PerformScript KeyboardManager ();
elif (index == 6) then
	PerformScript ScriptManager ();
elif (index == 7) then
	PerformScript GraphicsLabeler ();
EndIf
EndScript

; ***
; Window event functions
; ***
Void Function ForgroundWindowChanged (handle newWindow)
EndFunction

Void Function WindowCreatedEvent (handle hWindow, int nLeft, int nTop, int nRight, int nBottom)
; It is best to override this function in application specific script files.
; Any code placed here will be processed very frequently.
EndFunction

Function WindowDestroyedEvent (handle hWindow)
EndFunction

Function WindowMinMaxEvent (handle hWindow, int nMinMaxRest, int nShow)
EndFunction

Function WindowResizedEvent (handle hWindow, int nLeft, int nTop, int nRight, int nBottom)
EndFunction

;***
;	The following section contains scripts to control the JAWS verobosity 
;***

Script VerbosityLevel ()
Var
	int Verbosity
VerbosityLevel ()
let Verbosity = GetVerbosity ()
if Verbosity == 0 then
	SayString (msg14) ;"Beginner level"
	Return
endif
if Verbosity == 1 then
	SayString (msg15) ;"Intermediate level"
	Return
endif
if Verbosity == 2 then
	SayString (msg16) ;"Advanced level"
	Return
endif
EndScript

Script BrailleVerbosity ()

if  GetJcfOption (OPT_BRL_verbosity)==0
then SetJcfOption (OPT_BRL_verbosity, 1)
SayString("Braille Verbosity Intermediate")
elif  GetJcfOption (OPT_BRL_verbosity)==1
then SetJcfOption (OPT_BRL_verbosity, 2)
SayString("Braille Verbosity Advanced")
elif  GetJcfOption (OPT_BRL_verbosity)==2
then SetJcfOption (OPT_BRL_verbosity, 0)
SayString("Braille Verbosity Beginner")
endif
EndScript

Script ScreenEcho ()
ScreenEcho()
if GetScreenEcho() == 0 then
	sayString(msg17) ;"none"
endif
if GetScreenEcho() == 1 then
	SayString(msg18) ;"highlighted"
endif
if GetScreenEcho() == 2 then
	SayString(msg19) ;"all"
endif
EndScript

Script AnsiCharsDecrement ()
var
	int SpeakAnsiChars
Let SpeakAnsiChars = GetJcfOption (OPT_SPEAK_ANSI_CHARS)
If (SpeakAnsiChars == 0) then
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, 4 ) == WAS_SUCCESSFUL)  then
		SayString (msg82) ;"All Ansi"
	Else ; WAS_NOT_SUCCESSFUL
		SayString (msg83) ;"Was not able to set change the j c f option"
	EndIf
Else
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, SpeakAnsiChars - 1 ) == WAS_SUCCESSFUL)  then
		If (SpeakAnsiChars - 1) == 0 then
			SayString (msg84) ;"No Ansi"
		EndIf
		If (SpeakAnsiChars - 1) == 1 then
			SayString (msg85) ;"Some Ansi"
		EndIf
		If (SpeakAnsiChars - 1) == 2 then
			SayString (msg86) ;"More Ansi"
		EndIf
		If (SpeakAnsiChars - 1) == 3 then
			SayString (msg87) ;"Most Ansi"
		EndIf
	Else ; WAS_NOT_SUCCESSFUL
		SayString (msg83) ;"Was not able to set change the j c f option"
	EndIf
EndIf ; SpeakAnsiChars == 0
EndScript

Script AnsiCharsIncrement ()
var
	int SpeakAnsiChars
Let SpeakAnsiChars = GetJcfOption (OPT_SPEAK_ANSI_CHARS)
If (SpeakAnsiChars == 4) then
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, 0 ) == WAS_SUCCESSFUL)  then
		SayString (msg84) ;"No Ansi"
	Else ; WAS_NOT_SUCCESSFUL
		SayString (msg83) ;"Was not able to set change the j c f option"
	EndIf
Else
	If (SetJcfOption (OPT_SPEAK_ANSI_CHARS, SpeakAnsiChars + 1 ) == WAS_SUCCESSFUL)  then
		If (SpeakAnsiChars + 1) == 1 then
			SayString (msg85) ;"Some Ansi"
		EndIf
		If (SpeakAnsiChars + 1) == 2 then
			SayString (msg86) ;"More Ansi"
		EndIf
		If (SpeakAnsiChars + 1) == 3 then
			SayString (msg87) ;"Most Ansi"
		EndIf
		If (SpeakAnsiChars + 1) == 4 then
			SayString (msg82) ;"All Ansi"
		EndIf
	Else ; WAS_NOT_SUCCESSFUL
		SayString (msg83) ;"Was not able to set change the j c f option"
	EndIf
EndIf ; SpeakAnsiChars == 0
EndScript

Script TypingEcho ()
; Macro by Donny Dunn and Dennis Godin that toggles Typing Echo
Var
	Int Typing_Echo
Let Typing_Echo=GetDefaultJCFOption (opt_typing_Echo)
If (Typing_Echo == 2) Then
	SetDefaultJcfOption (Opt_Typing_Echo, 0)
	SayString (msg107) ;"None"
Else
	If (Typing_Echo == 0) Then
		SetDefaultJcfOption (Opt_Typing_Echo, 1)
		SayString (msg108) ;"Characters"
	Else
		If (Typing_Echo == 1) Then
			SetDefaultJcfOption (Opt_Typing_Echo, 2)
			SayString (msg109) ;"Words"
		EndIf
	EndIf
EndIf
EndScript

Script GraphicsVerbosity ()
var
	int currentSetting
let currentSetting = GetDefaultJCFOption (OPT_INCLUDE_GRAPHICS)
If (currentSetting == 2) Then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 0)
	SayString ("No graphics");
ElIf (currentSetting == 0) Then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 1)
	SayString ("Labeled")
ElIf (currentSetting == 1) Then
	SetDefaultJcfOption (OPT_INCLUDE_GRAPHICS, 2)
	SayString ("All graphics")
EndIf
EndScript

Script AdjustJAWSVerbosity ()
var
	string list

if (IsSpeechOff ()) then
	PerformScript MuteSynthesizer()
	return
endif

let list = VerbosityLevelItem + 
	GraphicsItem +
	AnsiCharsIncItem+
	BrailleVerbosityItem+
	ScreenEchoItem +
	TypingEchoItem  + 
	MuteSynth
	DlgSelectScriptToRun (list, AdjustJawsVerbosityDialogName, false)
EndScript

Function SayExtendedHelpHotKey ()

SayString(msg473)
SayString(GetWindowName (GetAppMainWindow (GetCurrentWindow ())))
SayString(msg474)

EndFunction

String Function GetCorrespondingHelpFile (string strApp)
var
string strHelpFile,
int nPeriod

let nPeriod = StringContains (strApp, ".")
let strApp = SubString (strApp, 1, nPeriod)

let strHelpFile = GetJawsHelpDirectory ()
let strHelpFile = strHelpFile + "\\"
let strHelpFile = strHelpFile + strApp
let strHelpFile = strHelpFile + "hlp"
return strHelpFile
EndFunction

Function AppFileTopic ()
var 
string strApp,
string strHelpFile

let strApp = GetAppFileName ()
let strApp = StringLower (strApp)
let strHelpFile = GetCorrespondingHelpFile (strApp)

StopSpeech ()

if (StringContains (strListOfAppsWithTopics, strApp)) then
	ShowHelpByName ("JFW", strApp)
elif (FileExists (strHelpFile) && !(StringContains (strListOfExcludedApps, strApp))) then
	ShowHelpByName (strHelpFile, strApp)
else
	SayString (msg453 + strApp)
endif
EndFunction

Void Function AppWillNotSpeakEvent (string strApp)
SayString (strApp + msg457)
EndFunction

Script MuteSynthesizer ()
if (IsSpeechOff ()) then
	SpeechOn()
	SayString(msg459); "Mute Off"
else
	SayString (msg458); "Mute On"
	SpeechOff()
endif
EndScript
